clear all
set more off
set matsize 1000
log using t3-4.txt, text replace

use regdata, replace

*
* sample selection
*
keep if year == 1980 | year == 1985 | year == 1990 | year == 1995 | year == 2000 | year == 2005 | year == 2011

keep if flag_mfg == 1

tabulate ind, gen(d_ind)
tabulate year, gen(d_year)

gen trend = year - 1980

*
* symmetry-constraint
*
constraint define 1  [s_l0m]w1mpm = [s_l1m]w0mpm
constraint define 2  [s_l0m]w2mpm = [s_l2m]w0mpm
constraint define 3  [s_l0m]w3mpm = [s_l3m]w0mpm
constraint define 4  [s_l0m]w0fpm = [s_l0f]w0mpm
constraint define 5  [s_l0m]w1fpm = [s_l1f]w0mpm
constraint define 6  [s_l0m]w2fpm = [s_l2f]w0mpm
constraint define 7  [s_l0m]w3fpm = [s_l3f]w0mpm
constraint define 8  [s_l1m]w2mpm = [s_l2m]w1mpm
constraint define 9  [s_l1m]w3mpm = [s_l3m]w1mpm
constraint define 10 [s_l1m]w0fpm = [s_l0f]w1mpm
constraint define 11 [s_l1m]w1fpm = [s_l1f]w1mpm
constraint define 12 [s_l1m]w2fpm = [s_l2f]w1mpm
constraint define 13 [s_l1m]w3fpm = [s_l3f]w1mpm
constraint define 14 [s_l2m]w3mpm = [s_l3m]w2mpm
constraint define 15 [s_l2m]w0fpm = [s_l0f]w2mpm
constraint define 16 [s_l2m]w1fpm = [s_l1f]w2mpm
constraint define 17 [s_l2m]w2fpm = [s_l2f]w2mpm
constraint define 18 [s_l2m]w3fpm = [s_l3f]w2mpm
constraint define 19 [s_l3m]w0fpm = [s_l0f]w3mpm
constraint define 20 [s_l3m]w1fpm = [s_l1f]w3mpm
constraint define 21 [s_l3m]w2fpm = [s_l2f]w3mpm
constraint define 22 [s_l3m]w3fpm = [s_l3f]w3mpm
constraint define 23 [s_l0f]w1fpm = [s_l1f]w0fpm
constraint define 24 [s_l0f]w2fpm = [s_l2f]w0fpm
constraint define 25 [s_l0f]w3fpm = [s_l3f]w0fpm
constraint define 26 [s_l1f]w2fpm = [s_l2f]w1fpm
constraint define 27 [s_l1f]w3fpm = [s_l3f]w1fpm
constraint define 28 [s_l2f]w3fpm = [s_l3f]w2fpm

*
* estimation
*
********************************************************************************************************************
*
* fixed effect SUR
*
********************************************************************************************************************
sureg (s_l0m w0mpm w0fpm w1mpm w1fpm w2mpm w2fpm w3mpm w3fpm itk nitk y nio trend d_year2-d_year7 d_ind*, noconstant) (s_l1m w0mpm w0fpm w1mpm w1fpm w2mpm w2fpm w3mpm w3fpm itk nitk y nio trend d_year2-d_year7 d_ind*, noconstant) (s_l2m w0mpm w0fpm w1mpm w1fpm w2mpm w2fpm w3mpm w3fpm itk nitk y nio trend d_year2-d_year7 d_ind*, noconstant) (s_l3m w0mpm w0fpm w1mpm w1fpm w2mpm w2fpm w3mpm w3fpm itk nitk y nio trend d_year2-d_year7 d_ind*, noconstant) (s_l0f w0mpm w0fpm w1mpm w1fpm w2mpm w2fpm w3mpm w3fpm itk nitk y nio trend d_year2-d_year7 d_ind*, noconstant) (s_l1f w0mpm w0fpm w1mpm w1fpm w2mpm w2fpm w3mpm w3fpm itk nitk y nio trend d_year2-d_year7 d_ind*, noconstant) (s_l2f w0mpm w0fpm w1mpm w1fpm w2mpm w2fpm w3mpm w3fpm itk nitk y nio trend d_year2-d_year7 d_ind*, noconstant) (s_l3f w0mpm w0fpm w1mpm w1fpm w2mpm w2fpm w3mpm w3fpm itk nitk y nio trend d_year2-d_year7 d_ind*, noconstant), const(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28) corr
outreg2 w0mpm w0fpm w1mpm w1fpm w2mpm w2fpm w3mpm w3fpm itk nitk y nio trend using outsourcing_t3-4, excel dec(3)
*****************************************************************************************************
* generate mean factor share
*
egen m_s_l0m = mean(s_l0m)
egen m_s_l1m = mean(s_l1m)
egen m_s_l2m = mean(s_l2m)
egen m_s_l3m = mean(s_l3m)

egen m_s_l0f = mean(s_l0f)
egen m_s_l1f = mean(s_l1f)
egen m_s_l2f = mean(s_l2f)
egen m_s_l3f = mean(s_l3f)

egen m_s_m  = mean(s_m)
*
* change to scalar
*
scalar m_sl0m = m_s_l0m
scalar m_sl1m = m_s_l1m
scalar m_sl2m = m_s_l2m
scalar m_sl3m = m_s_l3m
scalar m_sl0f = m_s_l0f
scalar m_sl1f = m_s_l1f
scalar m_sl2f = m_s_l2f
scalar m_sl3f = m_s_l3f
scalar m_sm  = m_s_m

drop m_s_l0m m_s_l1m m_s_l2m m_s_l3m m_s_l0f m_s_l1f m_s_l2f m_s_l3f m_s_m
*
* compute coefficients for material (Berndt, 1991, p. 473, equatnion (9.49))
*
quietly nlcom (gamma0mM: - ([s_l0m]_b[w0mpm] + [s_l1m]_b[w0mpm] + [s_l2m]_b[w0mpm] + [s_l3m]_b[w0mpm] + [s_l0f]_b[w0mpm] + [s_l1f]_b[w0mpm] + [s_l2f]_b[w0mpm] + [s_l3f]_b[w0mpm])) ///
(gamma1mM: - ([s_l0m]_b[w1mpm] + [s_l1m]_b[w1mpm] + [s_l2m]_b[w1mpm] + [s_l3m]_b[w1mpm] + [s_l0f]_b[w1mpm] + [s_l1f]_b[w1mpm] + [s_l2f]_b[w1mpm] + [s_l3f]_b[w1mpm])) ///
(gamma2mM: - ([s_l0m]_b[w2mpm] + [s_l1m]_b[w2mpm] + [s_l2m]_b[w2mpm] + [s_l3m]_b[w2mpm] + [s_l0f]_b[w2mpm] + [s_l1f]_b[w2mpm] + [s_l2f]_b[w2mpm] + [s_l3f]_b[w2mpm])) ///
(gamma3mM: - ([s_l0m]_b[w3mpm] + [s_l1m]_b[w3mpm] + [s_l2m]_b[w3mpm] + [s_l3m]_b[w3mpm] + [s_l0f]_b[w3mpm] + [s_l1f]_b[w3mpm] + [s_l2f]_b[w3mpm] + [s_l3f]_b[w3mpm])) ///
(gamma0fM: - ([s_l0m]_b[w0fpm] + [s_l1m]_b[w0fpm] + [s_l2m]_b[w0fpm] + [s_l3m]_b[w0fpm] + [s_l0f]_b[w0fpm] + [s_l1f]_b[w0fpm] + [s_l2f]_b[w0fpm] + [s_l3f]_b[w0fpm])) ///
(gamma1fM: - ([s_l0m]_b[w1fpm] + [s_l1m]_b[w1fpm] + [s_l2m]_b[w1fpm] + [s_l3m]_b[w1fpm] + [s_l0f]_b[w1fpm] + [s_l1f]_b[w1fpm] + [s_l2f]_b[w1fpm] + [s_l3f]_b[w1fpm])) ///
(gamma2fM: - ([s_l0m]_b[w2fpm] + [s_l1m]_b[w2fpm] + [s_l2m]_b[w2fpm] + [s_l3m]_b[w2fpm] + [s_l0f]_b[w2fpm] + [s_l1f]_b[w2fpm] + [s_l2f]_b[w2fpm] + [s_l3f]_b[w2fpm])) ///
(gamma3fM: - ([s_l0m]_b[w3fpm] + [s_l1m]_b[w3fpm] + [s_l2m]_b[w3fpm] + [s_l3m]_b[w3fpm] + [s_l0f]_b[w3fpm] + [s_l1f]_b[w3fpm] + [s_l2f]_b[w3fpm] + [s_l3f]_b[w3fpm])) ///
(gammaMM: [s_l0m]_b[w0mpm] + [s_l1m]_b[w0mpm] + [s_l2m]_b[w0mpm] + [s_l3m]_b[w0mpm] + [s_l0f]_b[w0mpm] + [s_l1f]_b[w0mpm] + [s_l2f]_b[w0mpm] + [s_l3f]_b[w0mpm] + [s_l0m]_b[w1mpm] + [s_l1m]_b[w1mpm] + [s_l2m]_b[w1mpm] + [s_l3m]_b[w1mpm] + [s_l0f]_b[w1mpm] + [s_l1f]_b[w1mpm] + [s_l2f]_b[w1mpm] + [s_l3f]_b[w1mpm] + [s_l0m]_b[w2mpm] + [s_l1m]_b[w2mpm] + [s_l2m]_b[w2mpm] + [s_l3m]_b[w2mpm] + [s_l0f]_b[w2mpm] + [s_l1f]_b[w2mpm] + [s_l2f]_b[w2mpm] + [s_l3f]_b[w2mpm] + [s_l0m]_b[w3mpm] + [s_l1m]_b[w3mpm] + [s_l2m]_b[w3mpm] + [s_l3m]_b[w3mpm] + [s_l0f]_b[w3mpm] + [s_l1f]_b[w3mpm] + [s_l2f]_b[w3mpm] + [s_l3f]_b[w3mpm] + [s_l0m]_b[w0fpm] + [s_l1m]_b[w0fpm] + [s_l2m]_b[w0fpm] + [s_l3m]_b[w0fpm] + [s_l0f]_b[w0fpm] + [s_l1f]_b[w0fpm] + [s_l2f]_b[w0fpm] + [s_l3f]_b[w0fpm] + [s_l0m]_b[w1fpm] + [s_l1m]_b[w1fpm] + [s_l2m]_b[w1fpm] + [s_l3m]_b[w1fpm] + [s_l0f]_b[w1fpm] + [s_l1f]_b[w1fpm] + [s_l2f]_b[w1fpm] + [s_l3f]_b[w1fpm] + [s_l0m]_b[w2fpm] + [s_l1m]_b[w2fpm] + [s_l2m]_b[w2fpm] + [s_l3m]_b[w2fpm] + [s_l0f]_b[w2fpm] + [s_l1f]_b[w2fpm] + [s_l2f]_b[w2fpm] + [s_l3f]_b[w2fpm] + [s_l0m]_b[w3fpm] + [s_l1m]_b[w3fpm] + [s_l2m]_b[w3fpm] + [s_l3m]_b[w3fpm] + [s_l0f]_b[w3fpm] + [s_l1f]_b[w3fpm] + [s_l2f]_b[w3fpm] + [s_l3f]_b[w3fpm]) ///
/*
*
* compute price elasticities (Berndt, 1991, p. 475, equations (9.50) & (9.51))
*
* own price elasticities
*
*/ ///
(sigma0m0m: [s_l0m]_b[w0mpm]/m_sl0m + m_sl0m - 1) ///
(sigma1m1m: [s_l1m]_b[w1mpm]/m_sl1m + m_sl1m - 1) ///
(sigma2m2m: [s_l2m]_b[w2mpm]/m_sl2m + m_sl2m - 1) ///
(sigma3m3m: [s_l3m]_b[w3mpm]/m_sl3m + m_sl3m - 1) ///
(sigma0f0f: [s_l0f]_b[w0fpm]/m_sl0f + m_sl0f - 1) ///
(sigma1f1f: [s_l1f]_b[w1fpm]/m_sl1f + m_sl1f - 1) ///
(sigma2f2f: [s_l2f]_b[w2fpm]/m_sl2f + m_sl2f - 1) ///
(sigma3f3f: [s_l3f]_b[w3fpm]/m_sl3f + m_sl3f - 1) ///
(sigmaMM: ([s_l0m]_b[w0mpm] + [s_l1m]_b[w0mpm] + [s_l2m]_b[w0mpm] + [s_l3m]_b[w0mpm] + [s_l0f]_b[w0mpm] + [s_l1f]_b[w0mpm] + [s_l2f]_b[w0mpm] + [s_l3f]_b[w0mpm] + [s_l0m]_b[w1mpm] + [s_l1m]_b[w1mpm] + [s_l2m]_b[w1mpm] + [s_l3m]_b[w1mpm] + [s_l0f]_b[w1mpm] + [s_l1f]_b[w1mpm] + [s_l2f]_b[w1mpm] + [s_l3f]_b[w1mpm] + [s_l0m]_b[w2mpm] + [s_l1m]_b[w2mpm] + [s_l2m]_b[w2mpm] + [s_l3m]_b[w2mpm] + [s_l0f]_b[w2mpm] + [s_l1f]_b[w2mpm] + [s_l2f]_b[w2mpm] + [s_l3f]_b[w2mpm] + [s_l0m]_b[w3mpm] + [s_l1m]_b[w3mpm] + [s_l2m]_b[w3mpm] + [s_l3m]_b[w3mpm] + [s_l0f]_b[w3mpm] + [s_l1f]_b[w3mpm] + [s_l2f]_b[w3mpm] + [s_l3f]_b[w3mpm] + [s_l0m]_b[w0fpm] + [s_l1m]_b[w0fpm] + [s_l2m]_b[w0fpm] + [s_l3m]_b[w0fpm] + [s_l0f]_b[w0fpm] + [s_l1f]_b[w0fpm] + [s_l2f]_b[w0fpm] + [s_l3f]_b[w0fpm] + [s_l0m]_b[w1fpm] + [s_l1m]_b[w1fpm] + [s_l2m]_b[w1fpm] + [s_l3m]_b[w1fpm] + [s_l0f]_b[w1fpm] + [s_l1f]_b[w1fpm] + [s_l2f]_b[w1fpm] + [s_l3f]_b[w1fpm] + [s_l0m]_b[w2fpm] + [s_l1m]_b[w2fpm] + [s_l2m]_b[w2fpm] + [s_l3m]_b[w2fpm] + [s_l0f]_b[w2fpm] + [s_l1f]_b[w2fpm] + [s_l2f]_b[w2fpm] + [s_l3f]_b[w2fpm] + [s_l0m]_b[w3fpm] + [s_l1m]_b[w3fpm] + [s_l2m]_b[w3fpm] + [s_l3m]_b[w3fpm] + [s_l0f]_b[w3fpm] + [s_l1f]_b[w3fpm] + [s_l2f]_b[w3fpm] + [s_l3f]_b[w3fpm])/m_sm + m_sm - 1) ///
/*
*
* cross-price elasticities
*
*/ ///
(sigma0m1m: ([s_l0m]_b[w1mpm]+m_sl0m*m_sl1m)/m_sl0m) ///
(sigma0m2m: ([s_l0m]_b[w2mpm]+m_sl0m*m_sl2m)/m_sl0m) ///
(sigma0m3m: ([s_l0m]_b[w3mpm]+m_sl0m*m_sl3m)/m_sl0m) ///
(sigma0m0f: ([s_l0m]_b[w0fpm]+m_sl0m*m_sl0f)/m_sl0m) ///
(sigma0m1f: ([s_l0m]_b[w1fpm]+m_sl0m*m_sl1f)/m_sl0m) ///
(sigma0m2f: ([s_l0m]_b[w2fpm]+m_sl0m*m_sl2f)/m_sl0m) ///
(sigma0m3f: ([s_l0m]_b[w3fpm]+m_sl0m*m_sl3f)/m_sl0m) ///
(sigma1m2m: ([s_l1m]_b[w2mpm]+m_sl1m*m_sl2m)/m_sl1m) ///
(sigma1m3m: ([s_l1m]_b[w3mpm]+m_sl1m*m_sl3m)/m_sl1m) ///
(sigma1m0f: ([s_l1m]_b[w0fpm]+m_sl1m*m_sl0f)/m_sl1m) ///
(sigma1m1f: ([s_l1m]_b[w1fpm]+m_sl1m*m_sl1f)/m_sl1m) ///
(sigma1m2f: ([s_l1m]_b[w2fpm]+m_sl1m*m_sl2f)/m_sl1m) ///
(sigma1m3f: ([s_l1m]_b[w3fpm]+m_sl1m*m_sl3f)/m_sl1m) ///
(sigma2m3m: ([s_l2m]_b[w3mpm]+m_sl2m*m_sl3m)/m_sl2m) ///
(sigma2m0f: ([s_l2m]_b[w0fpm]+m_sl2m*m_sl0f)/m_sl2m) ///
(sigma2m1f: ([s_l2m]_b[w1fpm]+m_sl2m*m_sl1f)/m_sl2m) ///
(sigma2m2f: ([s_l2m]_b[w2fpm]+m_sl2m*m_sl2f)/m_sl2m) ///
(sigma2m3f: ([s_l2m]_b[w3fpm]+m_sl2m*m_sl3f)/m_sl2m) ///
(sigma3m0f: ([s_l3m]_b[w0fpm]+m_sl3m*m_sl0f)/m_sl3m) ///
(sigma3m1f: ([s_l3m]_b[w1fpm]+m_sl3m*m_sl1f)/m_sl3m) ///
(sigma3m2f: ([s_l3m]_b[w2fpm]+m_sl3m*m_sl2f)/m_sl3m) ///
(sigma3m3f: ([s_l3m]_b[w3fpm]+m_sl3m*m_sl3f)/m_sl3m) ///
(sigma0f1f: ([s_l0f]_b[w1fpm]+m_sl0f*m_sl1f)/m_sl0f) ///
(sigma0f2f: ([s_l0f]_b[w2fpm]+m_sl0f*m_sl2f)/m_sl0f) ///
(sigma0f3f: ([s_l0f]_b[w3fpm]+m_sl0f*m_sl3f)/m_sl0f) ///
(sigma1f2f: ([s_l1f]_b[w2fpm]+m_sl1f*m_sl2f)/m_sl1f) ///
(sigma1f3f: ([s_l1f]_b[w3fpm]+m_sl1f*m_sl3f)/m_sl1f) ///
(sigma2f3f: ([s_l2f]_b[w3fpm]+m_sl2f*m_sl3f)/m_sl2f) ///
(sigma0mM: (- ([s_l0m]_b[w0mpm] + [s_l1m]_b[w0mpm] + [s_l2m]_b[w0mpm] + [s_l3m]_b[w0mpm] + [s_l0f]_b[w0mpm] + [s_l1f]_b[w0mpm] + [s_l2f]_b[w0mpm] + [s_l3f]_b[w0mpm]) + m_sl0m*m_sm)/m_sl0m) ///
(sigma1mM: (- ([s_l0m]_b[w1mpm] + [s_l1m]_b[w1mpm] + [s_l2m]_b[w1mpm] + [s_l3m]_b[w1mpm] + [s_l0f]_b[w1mpm] + [s_l1f]_b[w1mpm] + [s_l2f]_b[w1mpm] + [s_l3f]_b[w1mpm]) + m_sl1m*m_sm)/m_sl1m) ///
(sigma2mM: (- ([s_l0m]_b[w2mpm] + [s_l1m]_b[w2mpm] + [s_l2m]_b[w2mpm] + [s_l3m]_b[w2mpm] + [s_l0f]_b[w2mpm] + [s_l1f]_b[w2mpm] + [s_l2f]_b[w2mpm] + [s_l3f]_b[w2mpm]) + m_sl2m*m_sm)/m_sl2m) ///
(sigma3mM: (- ([s_l0m]_b[w3mpm] + [s_l1m]_b[w3mpm] + [s_l2m]_b[w3mpm] + [s_l3m]_b[w3mpm] + [s_l0f]_b[w3mpm] + [s_l1f]_b[w3mpm] + [s_l2f]_b[w3mpm] + [s_l3f]_b[w3mpm]) + m_sl3m*m_sm)/m_sl3m) ///
(sigma0fM: (- ([s_l0m]_b[w0fpm] + [s_l1m]_b[w0fpm] + [s_l2m]_b[w0fpm] + [s_l3m]_b[w0fpm] + [s_l0f]_b[w0fpm] + [s_l1f]_b[w0fpm] + [s_l2f]_b[w0fpm] + [s_l3f]_b[w0fpm]) + m_sl0f*m_sm)/m_sl0f) ///
(sigma1fM: (- ([s_l0m]_b[w1fpm] + [s_l1m]_b[w1fpm] + [s_l2m]_b[w1fpm] + [s_l3m]_b[w1fpm] + [s_l0f]_b[w1fpm] + [s_l1f]_b[w1fpm] + [s_l2f]_b[w1fpm] + [s_l3f]_b[w1fpm]) + m_sl1f*m_sm)/m_sl1f) ///
(sigma2fM: (- ([s_l0m]_b[w2fpm] + [s_l1m]_b[w2fpm] + [s_l2m]_b[w2fpm] + [s_l3m]_b[w2fpm] + [s_l0f]_b[w2fpm] + [s_l1f]_b[w2fpm] + [s_l2f]_b[w2fpm] + [s_l3f]_b[w2fpm]) + m_sl2f*m_sm)/m_sl2f) ///
(sigma3fM: (- ([s_l0m]_b[w3fpm] + [s_l1m]_b[w3fpm] + [s_l2m]_b[w3fpm] + [s_l3m]_b[w3fpm] + [s_l0f]_b[w3fpm] + [s_l1f]_b[w3fpm] + [s_l2f]_b[w3fpm] + [s_l3f]_b[w3fpm]) + m_sl3f*m_sm)/m_sl3f) ///
/*
*
* the elasticity with respect to exogenous variables
*
*/ ///
(sigma0mIT: [s_l0m]_b[itk]/m_sl0m) ///
(sigma1mIT: [s_l1m]_b[itk]/m_sl1m) ///
(sigma2mIT: [s_l2m]_b[itk]/m_sl2m) ///
(sigma3mIT: [s_l3m]_b[itk]/m_sl3m) ///
(sigma0fIT: [s_l0f]_b[itk]/m_sl0f) ///
(sigma1fIT: [s_l1f]_b[itk]/m_sl1f) ///
(sigma2fIT: [s_l2f]_b[itk]/m_sl2f) ///
(sigma3fIT: [s_l3f]_b[itk]/m_sl3f) ///
(sigmaMIT: - ([s_l0m]_b[itk] + [s_l1m]_b[itk] + [s_l2m]_b[itk] + [s_l3m]_b[itk] + [s_l0f]_b[itk] + [s_l1f]_b[itk] + [s_l2f]_b[itk] + [s_l3f]_b[itk])/m_sm) ///
(sigma0mNIT: [s_l0m]_b[nitk]/m_sl0m) ///
(sigma1mNIT: [s_l1m]_b[nitk]/m_sl1m) ///
(sigma2mNIT: [s_l2m]_b[nitk]/m_sl2m) ///
(sigma3mNIT: [s_l3m]_b[nitk]/m_sl3m) ///
(sigma0fNIT: [s_l0f]_b[nitk]/m_sl0f) ///
(sigma1fNIT: [s_l1f]_b[nitk]/m_sl1f) ///
(sigma2fNIT: [s_l2f]_b[nitk]/m_sl2f) ///
(sigma3fNIT: [s_l3f]_b[nitk]/m_sl3f) ///
(sigmaMNIT: - ([s_l0m]_b[nitk] + [s_l1m]_b[nitk] + [s_l2m]_b[nitk] + [s_l3m]_b[nitk] + [s_l0f]_b[nitk] + [s_l1f]_b[nitk] + [s_l2f]_b[nitk] + [s_l3f]_b[nitk])/m_sm) ///
(sigma0mY: [s_l0m]_b[y]/m_sl0m) ///
(sigma1mY: [s_l1m]_b[y]/m_sl1m) ///
(sigma2mY: [s_l2m]_b[y]/m_sl2m) ///
(sigma3mY: [s_l3m]_b[y]/m_sl3m) ///
(sigma0fY: [s_l0f]_b[y]/m_sl0f) ///
(sigma1fY: [s_l1f]_b[y]/m_sl1f) ///
(sigma2fY: [s_l2f]_b[y]/m_sl2f) ///
(sigma3fY: [s_l3f]_b[y]/m_sl3f) ///
(sigmaMY: - ([s_l0m]_b[y] + [s_l1m]_b[y] + [s_l2m]_b[y] + [s_l3m]_b[y] + [s_l0f]_b[y] + [s_l1f]_b[y] + [s_l2f]_b[y] + [s_l3f]_b[y])/m_sm) ///
(sigma0mIO: [s_l0m]_b[nio]/m_sl0m) ///
(sigma1mIO: [s_l1m]_b[nio]/m_sl1m) ///
(sigma2mIO: [s_l2m]_b[nio]/m_sl2m) ///
(sigma3mIO: [s_l3m]_b[nio]/m_sl3m) ///
(sigma0fIO: [s_l0f]_b[nio]/m_sl0f) ///
(sigma1fIO: [s_l1f]_b[nio]/m_sl1f) ///
(sigma2fIO: [s_l2f]_b[nio]/m_sl2f) ///
(sigma3fIO: [s_l3f]_b[nio]/m_sl3f) ///
(sigmaMIO: - ([s_l0m]_b[nio] + [s_l1m]_b[nio] + [s_l2m]_b[nio] + [s_l3m]_b[nio] + [s_l0f]_b[nio] + [s_l1f]_b[nio] + [s_l2f]_b[nio] + [s_l3f]_b[nio])/m_sm), post
nlcom
outreg2 using elasticity_t3-4, excel dec(3) replace
*
* clear memory
*
scalar drop _all

log close
