clear all
set more off
set matsize 1000
log using t1-2.txt, text replace

use regdata, replace
keep if year >= 1980 & year <= 2011
keep if flag_mfg == 1



*
* Table 1 Average cost share
*

*** Female and male workers ***

tabstat s_l3f s_l2f s_l1f s_l0f if year == 1980 | year == 1985 | year == 1990 | year == 1995 | year == 2000 | year == 2005 | year == 2011, stat(mean sd min max) format(%9.4f) col(stat)
tabstat s_l3m s_l2m s_l1m s_l0m if year == 1980 | year == 1985 | year == 1990 | year == 1995 | year == 2000 | year == 2005 | year == 2011, stat(mean sd min max) format(%9.4f) col(stat)

*** Intermediate inputs ***

tabstat s_m if year == 1980 | year == 1985 | year == 1990 | year == 1995 | year == 2000 | year == 2005 | year == 2011, stat(mean sd min max) format(%9.4f) col(stat)


*
* Table 1 Annual change
*

preserve
keep if year == 1980 | year == 2011
replace year = 0 if year == 1980
replace year = 1 if year == 2011
xtset ind year
sort ind year
forvalues i = 0/3 {
   by ind: gen cs_l`i'f = (1/31)*(s_l`i'f - L.s_l`i'f)
   by ind: gen cs_l`i'm = (1/31)*(s_l`i'm - L.s_l`i'm)
   by ind: gen gl`i'f = (1/31)*ln(l`i'f/L.l`i'f)
   by ind: gen gl`i'm = (1/31)*ln(l`i'm/L.l`i'm)
   by ind: gen gW`i'f = (1/31)*ln(W`i'f/ L.W`i'f)
   by ind: gen gW`i'm = (1/31)*ln(W`i'm/ L.W`i'm)
}
by ind: gen cs_m = (1/31)*(s_m - L.s_m)
by ind: gen gM = (1/31)*ln(II_r/L.II_r)
by ind: gen gP_M = (1/31)*ln(P_II/L.P_II)
by ind: gen gITK = (1/31)*ln(ITK/L.ITK)
by ind: gen gNITK = (1/31)*ln(NITK/L.NITK)
by ind: gen gY = (1/31)*ln(VA_r/L.VA_r)


*
* Table 1
*

*** Female and male workers ***

* Annual change of cost shares
tabstat cs_l3f cs_l2f cs_l1f cs_l0f, stat(mean sd min max) format(%9.4f) col(stat)
tabstat cs_l3m cs_l2m cs_l1m cs_l0m, stat(mean sd min max) format(%9.4f) col(stat)

* Annual change of input quantities
tabstat gl3f gl2f gl1f gl0f, stat(mean sd min max) format(%9.4f) col(stat)
tabstat gl3m gl2m gl1m gl0m, stat(mean sd min max) format(%9.4f) col(stat)

* Annual change of flexible factor prices
tabstat gW3f gW2f gW1f gW0f, stat(mean sd min max) format(%9.4f) col(stat)
tabstat gW3m gW2m gW1m gW0m, stat(mean sd min max) format(%9.4f) col(stat)

*** Intermediate inputs ***

* Annual change of cost shares, input quantities, and flexible factor prices
tabstat cs_m gM gP_M, stat(mean sd min max) format(%9.4f) col(stat)

*** Annual change of fixed input and output quantities ***
tabstat gITK gNITK gY, stat(mean sd min max) format(%9.4f) col(stat)

restore


*
* Table 2
*

table year if year == 1980 | year == 1985 | year == 1990 | year == 1995 | year == 2000 | year == 2005 | year == 2011, c(m nio m bio m s_ITK) format(%9.4f)

clear
log close
