clear all
set more off
set matsize 1000
log using t5.txt, text replace
*
use regdata, replace
*
* sample selection
*
keep if year == 1980 | year == 1985 | year == 1990 | year == 1995 | year == 2000 | year == 2005 | year == 2011

keep if flag_mfg == 1

tabulate ind, gen(d_ind)
tabulate year, gen(d_year)

gen trend = year - 1980
*
* symmetry-constraint
*
constraint define 1 [s_l0]w1pm = [s_l1]w0pm
constraint define 2 [s_l0]w2pm = [s_l2]w0pm
constraint define 3 [s_l0]w3pm = [s_l3]w0pm
constraint define 4 [s_l1]w2pm = [s_l2]w1pm
constraint define 5 [s_l1]w3pm = [s_l3]w1pm
constraint define 6 [s_l2]w3pm = [s_l3]w2pm

*
* estimation
*
********************************************************************************************************************
*
* baseline: fixed effect SUR
*
********************************************************************************************************************
sureg (s_l3 w3pm w2pm w1pm w0pm nio itk nitk y trend d_year2-d_year7 d_ind*, noconstant) (s_l2 w3pm w2pm w1pm w0pm nio itk nitk y trend d_year2-d_year7 d_ind*, noconstant) (s_l1 w3pm w2pm w1pm w0pm nio itk nitk y trend d_year2-d_year7 d_ind*, noconstant) (s_l0 w3pm w2pm w1pm w0pm nio itk nitk y trend d_year2-d_year7 d_ind*, noconstant), const(1 2 3 4 5 6) corr
outreg2 w3pm w2pm w1pm w0pm nio itk nitk y trend using outsourcing_t5, excel dec(3)
*****************************************************************************************************
* generate mean factor share
*
egen m_s_l0 = mean(s_l0)
egen m_s_l1 = mean(s_l1)
egen m_s_l2 = mean(s_l2)
egen m_s_l3 = mean(s_l3)
egen m_s_m  = mean(s_m)
*
* change to scalar
*
scalar m_sl0 = m_s_l0
scalar m_sl1 = m_s_l1
scalar m_sl2 = m_s_l2
scalar m_sl3 = m_s_l3
scalar m_sm  = m_s_m
drop m_s_l0 m_s_l1 m_s_l2 m_s_l3 m_s_m
*
* compute coefficients for material (Berndt, 1991, p. 473, equatnion (9.49))
*
quietly nlcom (gamma3M: - ([s_l0]_b[w3pm] + [s_l1]_b[w3pm] + [s_l2]_b[w3pm] + [s_l3]_b[w3pm])) ///
(gamma2M: - ([s_l0]_b[w2pm] + [s_l1]_b[w2pm] + [s_l2]_b[w2pm] + [s_l3]_b[w2pm])) ///
(gamma1M: - ([s_l0]_b[w1pm] + [s_l1]_b[w1pm] + [s_l2]_b[w1pm] + [s_l3]_b[w1pm])) ///
(gamma0M: - ([s_l0]_b[w0pm] + [s_l1]_b[w0pm] + [s_l2]_b[w0pm] + [s_l3]_b[w0pm])) ///
(gammaMM: [s_l0]_b[w0pm] + [s_l0]_b[w1pm] + [s_l0]_b[w2pm] + [s_l0]_b[w3pm] + [s_l1]_b[w0pm] + [s_l1]_b[w1pm] + [s_l1]_b[w2pm] + [s_l1]_b[w3pm] + [s_l2]_b[w0pm] + [s_l2]_b[w1pm] + [s_l2]_b[w2pm] + [s_l2]_b[w3pm] + [s_l3]_b[w0pm] + [s_l3]_b[w1pm] + [s_l3]_b[w2pm] + [s_l3]_b[w3pm]) ///
/*
*
* compute price elasticities (Berndt, 1991, p. 475, equations (9.50) & (9.51))
*
* own price elasticities
*
*/ ///
(sigma33: [s_l3]_b[w3pm]/m_sl3 + m_sl3 - 1) ///
(sigma22: [s_l2]_b[w2pm]/m_sl2 + m_sl2 - 1) ///
(sigma11: [s_l1]_b[w1pm]/m_sl1 + m_sl1 - 1) ///
(sigma00: [s_l0]_b[w0pm]/m_sl0 + m_sl0 - 1) ///
(sigmaMM: ([s_l0]_b[w0pm] + [s_l0]_b[w1pm] + [s_l0]_b[w2pm] + [s_l0]_b[w3pm] + [s_l1]_b[w0pm] + [s_l1]_b[w1pm] + [s_l1]_b[w2pm] + [s_l1]_b[w3pm] + [s_l2]_b[w0pm] + [s_l2]_b[w1pm] + [s_l2]_b[w2pm] + [s_l2]_b[w3pm] + [s_l3]_b[w0pm] + [s_l3]_b[w1pm] + [s_l3]_b[w2pm] + [s_l3]_b[w3pm])/m_sm + m_sm - 1) ///
/*
*
* cross-price elasticities
*
*/ ///
(sigma03: ([s_l0]_b[w3pm]+m_sl0*m_sl3)/m_sl0) ///
(sigma02: ([s_l0]_b[w2pm]+m_sl0*m_sl2)/m_sl0) ///
(sigma01: ([s_l0]_b[w1pm]+m_sl0*m_sl1)/m_sl0) ///
(sigma13: ([s_l1]_b[w3pm]+m_sl1*m_sl3)/m_sl1) ///
(sigma12: ([s_l1]_b[w2pm]+m_sl1*m_sl2)/m_sl1) ///
(sigma23: ([s_l2]_b[w3pm]+m_sl2*m_sl3)/m_sl2) ///
(sigma3M: (- ([s_l0]_b[w3pm] + [s_l1]_b[w3pm] + [s_l2]_b[w3pm] + [s_l3]_b[w3pm]) + m_sl3*m_sm)/m_sl3) ///
(sigma2M: (- ([s_l0]_b[w2pm] + [s_l1]_b[w2pm] + [s_l2]_b[w2pm] + [s_l3]_b[w2pm]) + m_sl2*m_sm)/m_sl2) ///
(sigma1M: (- ([s_l0]_b[w1pm] + [s_l1]_b[w1pm] + [s_l2]_b[w1pm] + [s_l3]_b[w1pm]) + m_sl1*m_sm)/m_sl1) ///
(sigma0M: (- ([s_l0]_b[w0pm] + [s_l1]_b[w0pm] + [s_l2]_b[w0pm] + [s_l3]_b[w0pm]) + m_sl0*m_sm)/m_sl0) ///
/*
*
* the elasticity with respect to exogenous variables
*
*/ ///
(sigma3IT: [s_l3]_b[itk]/m_sl3) ///
(sigma2IT: [s_l2]_b[itk]/m_sl2) ///
(sigma1IT: [s_l1]_b[itk]/m_sl1) ///
(sigma0IT: [s_l0]_b[itk]/m_sl0) ///
(sigmaMIT: - ([s_l0]_b[itk] + [s_l1]_b[itk] + [s_l2]_b[itk] + [s_l3]_b[itk])/m_sm) ///
(sigma3NIT: [s_l3]_b[nitk]/m_sl3) ///
(sigma2NIT: [s_l2]_b[nitk]/m_sl2) ///
(sigma1NIT: [s_l1]_b[nitk]/m_sl1) ///
(sigma0NIT: [s_l0]_b[nitk]/m_sl0) ///
(sigmaMNIT: - ([s_l0]_b[nitk] + [s_l1]_b[nitk] + [s_l2]_b[nitk] + [s_l3]_b[nitk])/m_sm) ///
(sigma3Y: [s_l3]_b[y]/m_sl3) ///
(sigma2Y: [s_l2]_b[y]/m_sl2) ///
(sigma1Y: [s_l1]_b[y]/m_sl1) ///
(sigma0Y: [s_l0]_b[y]/m_sl0) ///
(sigmaMY: - ([s_l0]_b[y] + [s_l1]_b[y] + [s_l2]_b[y] + [s_l3]_b[y])/m_sm) ///
(sigma3IO: [s_l3]_b[nio]/m_sl3) ///
(sigma2IO: [s_l2]_b[nio]/m_sl2) ///
(sigma1IO: [s_l1]_b[nio]/m_sl1) ///
(sigma0IO: [s_l0]_b[nio]/m_sl0) ///
(sigmaMIO: - ([s_l0]_b[nio] + [s_l1]_b[nio] + [s_l2]_b[nio] + [s_l3]_b[nio])/m_sm), post
nlcom
outreg2 using elasticity_t5, excel dec(3)
*
* clear memory
*
scalar drop _all

log close
