clear all
set more off
set matsize 1000
log using t1-3.txt, text replace

use regdata, replace
keep if year >= 1980 & year <= 2011
keep if flag_mfg == 1

*
* generate variables: growth rate or change
*
* Table 1
*
tabstat s_l3 s_l2 s_l1 s_l0 s_m if year == 1980 | year == 1985 | year == 1990 | year == 1995 | year == 2000 | year == 2005 | year == 2011, stat(n mean sd min max) format(%9.4f) col(stat)

*
* Table 2 data preparation
*
preserve
keep if year == 1980 | year == 2011
replace year = 0 if year == 1980
replace year = 1 if year == 2011
xtset ind year
sort ind year
forvalues i = 0/3 {
   by ind: gen cs_l`i' = (1/31)*(s_l`i' - L.s_l`i')
   by ind: gen gl`i' = (1/31)*ln(l`i'/L.l`i')
   by ind: gen gW`i' = (1/31)*ln(W`i'/ L.W`i')
}
by ind: gen gP_M = (1/31)*ln(P_II/L.P_II)
by ind: gen gM = (1/31)*ln(II_r/L.II_r)
by ind: gen gITK = (1/31)*ln(ITK/L.ITK)
by ind: gen gNITK = (1/31)*ln(NITK/L.NITK)
by ind: gen gY = (1/31)*ln(VA_r/L.VA_r)
by ind: gen cs_m = (1/31)*(s_m - L.s_m)
by ind: gen cnio = (1/31)*(nio - L.nio)
by ind: gen cbio = (1/31)*(bio - L.bio)
*
* Table 2
*
* Cost shares
tabstat cs_l3 cs_l2 cs_l1 cs_l0 cs_m, stat(n mean sd min max) format(%9.4f) col(stat)
* Input quantities
tabstat gl3 gl2 gl1 gl0 gM, stat(n mean sd min max) format(%9.4f) col(stat)
* Flexible factor prices
tabstat gW3 gW2 gW1 gW0 gP_M, stat(n mean sd min max) format(%9.4f) col(stat)
* Fixed input and output quantities
tabstat gITK gNITK gY, stat(n mean sd min max) format(%9.4f) col(stat)

restore

*
* Table 3
*
table year if year == 1980 | year == 1985 | year == 1990 | year == 1995 | year == 2000 | year == 2005 | year == 2011, c(m nio m bio m s_ITK) format(%9.4f)

clear
log close
