clear all
set more off
set matsize 1000
log using t4.txt, text replace
*
use regdata_t4, replace
*
* sample selection
*
keep if year == 1980 | year == 1985 | year == 1990 | year == 1995 | year == 2000 | year == 2005 | year == 2011

keep if flag_mfg == 1

tabulate ind, gen(d_ind)
tabulate year, gen(d_year)

gen trend = year - 1980
*
* symmetry-constraint
*
constraint define 1 [s_l0]w1pm = [s_l1]w0pm

*
* estimation
*
********************************************************************************************************************
*
* fixed effect SUR
*
********************************************************************************************************************
sureg (s_l1 w1pm w0pm nio itk nitk y trend d_year2-d_year7 d_ind*, noconstant) (s_l0 w1pm w0pm nio itk nitk y trend d_year2-d_year7 d_ind*, noconstant), const(1) corr
outreg2 w1pm w0pm itk nitk y nio trend using outsourcing_t4, excel dec(3) replace
*****************************************************************************************************
* generate mean factor share
*
egen m_s_l0 = mean(s_l0)
egen m_s_l1 = mean(s_l1)
egen m_s_m  = mean(s_m)
*
* change to scalar
*
scalar m_sl0 = m_s_l0
scalar m_sl1 = m_s_l1
scalar m_sm  = m_s_m
drop m_s_l0 m_s_l1 m_s_m
*
* compute coefficients for material (Berndt, 1991, p. 473, equatnion (9.49))
*
quietly nlcom (gamma1M: - ([s_l0]_b[w1pm] + [s_l1]_b[w1pm])) ///
(gamma0M: - ([s_l0]_b[w0pm] + [s_l1]_b[w0pm])) ///
(gammaMM: [s_l0]_b[w0pm] + [s_l1]_b[w1pm] + [s_l1]_b[w0pm] + [s_l0]_b[w1pm]) ///
/*
*
* compute price elasticities (Berndt, 1991, p. 475, equations (9.50) & (9.51))
*
* own price elasticities
*
*/ ///
(sigma11: [s_l1]_b[w1pm]/m_sl1 + m_sl1 - 1) ///
(sigma00: [s_l0]_b[w0pm]/m_sl0 + m_sl0 - 1) ///
(sigmaMM: ([s_l0]_b[w0pm] + [s_l1]_b[w1pm] + [s_l1]_b[w0pm] + [s_l0]_b[w1pm])/m_sm + m_sm - 1) ///
/*
*
* cross-price elasticities
*
*/ ///
(sigma01: ([s_l0]_b[w1pm]+m_sl0*m_sl1)/m_sl0) ///
(sigma1M: (- ([s_l0]_b[w1pm] + [s_l1]_b[w1pm]) + m_sl1*m_sm)/m_sl1) ///
(sigma0M: (- ([s_l0]_b[w0pm] + [s_l1]_b[w0pm]) + m_sl0*m_sm)/m_sl0) ///
/*
*
* the elasticity with respect to exogenous variables
*
*/ ///
(sigma1IT: [s_l1]_b[itk]/m_sl1) ///
(sigma0IT: [s_l0]_b[itk]/m_sl0) ///
(sigmaMIT: - ([s_l0]_b[itk] + [s_l1]_b[itk])/m_sm) ///
(sigma1NIT: [s_l1]_b[nitk]/m_sl1) ///
(sigma0NIT: [s_l0]_b[nitk]/m_sl0) ///
(sigmaMNIT: - ([s_l0]_b[nitk] + [s_l1]_b[nitk])/m_sm) ///
(sigma1Y: [s_l1]_b[y]/m_sl1) ///
(sigma0Y: [s_l0]_b[y]/m_sl0) ///
(sigmaMY: - ([s_l0]_b[y] + [s_l1]_b[y])/m_sm) ///
(sigma1IO: [s_l1]_b[nio]/m_sl1) ///
(sigma0IO: [s_l0]_b[nio]/m_sl0) ///
(sigmaMIO: - ([s_l0]_b[nio] + [s_l1]_b[nio])/m_sm), post
nlcom
outreg2 using elasticity_t4, excel dec(3) replace
*
* clear memory
*
scalar drop _all

log close
