log using t1-7.txt, text replace
*
* This is a replication program (stata 17.0) for:
*
* Kiyota, Kozo and Yoshinori Kurokawa (2021) "Factor Intensity Reversals Redux: Feenstra Is Right!"
* Tables 1, 2, 3, 6, and 7
*
* Please note that the different version of the software may generate slightly different results from the published version.
*
clear all
set more off
set matsize 5000
use Kiyota_Kurokawa_2021_FIR, clear
*******************************************************************************************************************
* Table 1
*******************************************************************************************************************
preserve
keep if year == 2005
keep if ind >= 3 & ind <= 15
keep region prefecture ind K LH KL
reshape wide K LH KL, i(region prefecture) j(ind)
gen KL0 = (K3+K4+K5+K6+K7+K8+K9+K10+K11+K12+K13+K14+K15)/(LH3+LH4+LH5+LH6+LH7+LH8+LH9+LH10+LH11+LH12+LH13+LH14+LH15)
keep region prefecture KL*
outsheet using t1.csv, com replace
restore
*******************************************************************************************************************
* Table 2
*******************************************************************************************************************
preserve
keep if year == 2005
*keep if ind >= 3 & ind <= 15
keep region prefecture ind K LH KL
reshape wide K LH KL, i(region prefecture) j(ind)
gen KL0 = (K1+K2+K3+K4+K5+K6+K7+K8+K9+K10+K11+K12+K13+K14+K15)/(LH1+LH2+LH3+LH4+LH5+LH6+LH7+LH8+LH9+LH10+LH11+LH12+LH13+LH14+LH15)
keep region prefecture KL*
outsheet using t2.csv, com replace
restore
*******************************************************************************************************************
* Table 3
*******************************************************************************************************************
preserve
keep if year == 2005
keep if ind >= 3 & ind <= 15
gen KwL = K/wL
keep region prefecture ind K wL KwL
reshape wide K wL KwL, i(region prefecture) j(ind)
gen KwL0 = (K3+K4+K5+K6+K7+K8+K9+K10+K11+K12+K13+K14+K15)/(wL3+wL4+wL5+wL6+wL7+wL8+wL9+wL10+wL11+wL12+wL13+wL14+wL15)
keep region prefecture KwL*
outsheet using t3.csv, com replace
restore
*******************************************************************************************************************
* Table 4
* see t4.do
*******************************************************************************************************************
*
*******************************************************************************************************************
* Table 5
* cannot be disclosed due to the confidentiality of the data
*******************************************************************************************************************
*
*******************************************************************************************************************
* Table 6
*
* 6, 8, 9, 10, 11, 12, 13 = net export industries
* 3, 4, 5, 7, 14, 15 = net import industries
*******************************************************************************************************************
preserve
keep if year == 2005
keep if ind >= 3 & ind <= 15
replace ind = 1 if ind == 3 | ind == 4 | ind == 5 | ind == 7 | ind == 14 | ind == 15
replace ind = 2 if ind == 6 | ind == 8 | ind == 9 | ind == 10 | ind == 11 | ind == 12 | ind == 13
keep prefecture ind K LH
collapse (sum) K LH, by(prefecture ind)
gen KL = K/LH
reshape wide K LH KL, i(prefecture) j(ind)
gen KL0 = (K1+K2)/(LH1+LH2)
keep prefecture KL*
outsheet using t6.csv, com replace
restore
*******************************************************************************************************************
* Table 7
*
* 6, 8, 9, 10, 11, 12, 13 = net export industries
* 3, 4, 5, 7, 14, 15 = net import industries
*******************************************************************************************************************
preserve
keep if year == 2005
keep if ind >= 3 & ind <= 15
replace ind = 1 if ind == 3 | ind == 4 | ind == 5 | ind == 7 | ind == 14 | ind == 15
replace ind = 2 if ind == 6 | ind == 8 | ind == 9 | ind == 10 | ind == 11 | ind == 12 | ind == 13

keep prefecture ind K wL
collapse (sum) K wL, by(prefecture ind)
gen KwL = K/wL
reshape wide K wL KwL, i(prefecture) j(ind)
gen KwL0 = (K1+K2)/(wL1+wL2)
keep prefecture KwL*
outsheet using t7.csv, com replace
restore

log close
