log using tc1fc1.txt, text replace
*
* This is a replication program (stata 17.0) for:
*
* Kiyota, Kozo and Yoshinori Kurokawa (2021) "Factor Intensity Reversals Redux: Feenstra Is Right!"
* Table C1 and Figure C1
*
* Please note that the different version of the software may generate slightly different results from the published version.
*
clear all
set more off
set matsize 5000
use Kiyota_Kurokawa_2021_FIR, clear

*********************************************************************************************
* Figure C1
*********************************************************************************************

gen lnVA = ln(VA)
gen logKL = log10(KL)
gen logw = log10(wL/LH)
keep if year == 1975 | year == 1985 | year == 1995 | year == 2005
drop if prefecture == 0
keep if ind >= 3 & ind <= 15
twoway lfit logw logKL if ind == 3 || lfit logw logKL if ind == 4 || lfit logw logKL if ind == 5 || lfit logw logKL if ind == 6 || lfit logw logKL if ind == 7 || lfit logw logKL if ind == 8 || lfit logw logKL if ind == 9 || lfit logw logKL if ind == 10 || lfit logw logKL if ind == 11 || lfit logw logKL if ind == 12 || lfit logw logKL if ind == 13 || lfit logw logKL if ind == 14 || lfit logw logKL if ind == 15, by(year, note("") legend(off) yrescale xrescale) ytitle("Fitted value of log(w/r)") xtitle("log(K/L)")
graph export fc1.pdf, replace
*
keep if year == 2005

*********************************************************************************************
* Table C1
*********************************************************************************************

preserve
reg logw logKL, robust
outreg using tc1.csv, com bracket 3aster coefastr se replace
nlcom (1/_b[logKL])
matrix M = r(b)
matrix N = r(V)
matrix m = vec(M)
matrix n = vec(N)
svmat m, names(sigma)
svmat n, names(sigma_se)
rename sigma1 sigma
rename sigma_se1 sigma_se
keep sigma sigma_se
drop if sigma == .
replace sigma_se = sigma_se^(1/2)
restore
*
* by industry
*
forvalues i = 3/15 {
   preserve
   keep if ind == `i'
   display "*** industry == `i' ***"
   reg logw logKL, robust
   outreg using tc1.csv, com bracket 3aster coefastr se append
   nlcom (1/_b[logKL])
   matrix M = r(b)
   matrix N = r(V)
   matrix m = vec(M)
   matrix n = vec(N)
   svmat m, names(sigma)
   svmat n, names(sigma_se)
   rename sigma1 sigma
   rename sigma_se1 sigma_se
   keep sigma sigma_se
   drop if sigma == .
   replace sigma_se = sigma_se^(1/2)
   restore
   }

log close