quietly log using f5t5.log, text replace
*
* Figure 5 & Table 5
*
clear all
set more off

**************************************************************************************************
* Table 5: Three-good, two-cone model (baseline model in Table 2)
**************************************************************************************************

use regdata, replace

gen m = 0.4
gen n = 1
	sort year
	by year: gen HOind = 1 if logKitLit < m
	by year: replace HOind = 2 if logKitLit >= m & logKitLit < n
	by year: replace HOind = 3 if logKitLit >= n
	*
	* aggregation id
	*
	sort year HOind
	gen year_HOind_id = string(year) + "-" + string(HOind)
	*
	* aggregation
	*
	keep year_HOind_id HOind year VAit Kt Lt wt
	collapse (mean) year HOind Kt Lt wt (sum) VAit, by(year_HOind_id)
	*
	* New id (year x HO aggregation)
	*
	sort year HOind
	gen temp_id = string(year) + "-" + string(HOind)
	sort temp_id
	egen id = group(temp_id)
	drop temp_id
	*
	* Heckscher-Ohlin aggregate of VAL
	*
	gen VAL_HO = VAit/Lt
	gen KtLt = Kt/Lt
	*
	* intercept
	*
	gen intercept = 1
	*
	* industry dummies
	*
	tabulate HOind, generate(HOind_d)
	*
	* d
	*
		*
		* suppress constraint
		*
		keep year VAL_HO KtLt wt HOind
		sort year
		reshape wide VAL_HO, i(year) j(HOind)
		replace VAL_HO1 = 0 if VAL_HO1 == .
		replace VAL_HO2 = 0 if VAL_HO2 == .
		replace VAL_HO3 = 0 if VAL_HO3 == .

gen i = 10
gen j = 23.63904

		gen     d1 = 0
		replace d1 = 1 if KtLt <= i
		gen     d2 = 0
		replace d2 = 1 if KtLt > i
		gen KtLt_HO1 = (KtLt - i)*d1
		gen KtLt_HO2 = KtLt*d1+(i/(i-j))*(KtLt-j)*d2
		gen KtLt_HO3 = (KtLt-i)*d2

		bootstrap, reps(1000) seed(10101) nodots: sureg (VAL_HO1 KtLt_HO1, noconstant) (VAL_HO2 KtLt_HO2, noconstant) (VAL_HO3 KtLt_HO3, noconstant), small dfk

sureg, notable noheader corr
estat ic

**************************************************************************************************
* Figure 4 & Table 5: Four-good, three-cone model
**************************************************************************************************

use regdata, clear

gen m = 0.4
gen n = 0.7
gen o = 1.0
	sort year
	by year: gen HOind = 1 if logKitLit < m
	by year: replace HOind = 2 if logKitLit >= m & logKitLit < n
	by year: replace HOind = 3 if logKitLit >= n & logKitLit < o
	by year: replace HOind = 4 if logKitLit >= o
	*
	* aggregation id
	*
	sort year HOind
	gen year_HOind_id = string(year) + "-" + string(HOind)
	*
	* aggregation
	*
	keep year_HOind_id HOind year VAit Kt Lt wt
	collapse (mean) year HOind Kt Lt wt (sum) VAit, by(year_HOind_id)
	*
	* New id (year x HO aggregation)
	*
	sort year HOind
	gen temp_id = string(year) + "-" + string(HOind)
	sort temp_id
	egen id = group(temp_id)
	drop temp_id
	*
	* Heckscher-Ohlin aggregate of VAL
	*
	gen VAL_HO = VAit/Lt
	gen KtLt = Kt/Lt
	*
	* intercept
	*
	gen intercept = 1
	*
	* industry dummies
	*
	tabulate HOind, generate(HOind_d)
	*
	* d
	*
		*
		* suppress constraint
		*
		keep year VAL_HO KtLt wt HOind
		sort year
		reshape wide VAL_HO, i(year) j(HOind)
		replace VAL_HO1 = 0 if VAL_HO1 == .
		replace VAL_HO2 = 0 if VAL_HO2 == .
		replace VAL_HO3 = 0 if VAL_HO3 == .
		replace VAL_HO4 = 0 if VAL_HO4 == .

gen i = 9
gen j = 10
gen k = 23.63904

		gen     d1 = 0
		replace d1 = 1 if KtLt <= i
		gen     d2 = 0
		replace d2 = 1 if KtLt > i & KtLt <= j
		gen     d3 = 0
		replace d3 = 1 if KtLt > j
		gen KtLt_HO1 = (KtLt - i)*d1
		gen KtLt_HO2 = KtLt*d1 + (i/(i-j))*(KtLt-j)*d2
		gen KtLt_HO3 = (KtLt-i)*d2+((j-i)/(j-k))*(KtLt-k)*d3
		gen KtLt_HO4 = (KtLt-j)*d3

		bootstrap, reps(1000) seed(10101) nodots: sureg (VAL_HO1 KtLt_HO1, noconstant) (VAL_HO2 KtLt_HO2, noconstant) (VAL_HO3 KtLt_HO3, noconstant) (VAL_HO4 KtLt_HO4, noconstant), small dfk

sureg, notable noheader corr
estat ic

	set obs 33
	replace year = 3001 in 33
	replace KtLt = 0 in 33
	replace KtLt_HO1 = KtLt - 9 in 33
	replace KtLt_HO2 = 0 in 33
	replace KtLt_HO3 = 0 in 33
	replace KtLt_HO4 = 0 in 33
	replace VAL_HO1 = ([#1]_b[KtLt_HO1])*(KtLt-9) in 33
	replace VAL_HO2 = 0 in 33
	replace VAL_HO3 = 0 in 33
	replace VAL_HO4 = 0 in 33

	set obs 34
	replace year = 3002 in 34
	replace KtLt = 9 in 34
	replace KtLt_HO1 = KtLt - 9 in 34
	replace KtLt_HO2 = KtLt in 34
	replace KtLt_HO3 = KtLt - 9 in 34
	replace KtLt_HO4 = 0 in 34
	replace VAL_HO1 = ([#1]_b[KtLt_HO1])*(KtLt-9) in 34
	replace VAL_HO2 = ([#2]_b[KtLt_HO2])*KtLt in 34
	replace VAL_HO3 = ([#3]_b[KtLt_HO3])*(KtLt-9) in 34
	replace VAL_HO4 = 0 in 34

	set obs 35
	replace year = 3003 in 35
	replace KtLt = 10 in 35
	replace KtLt_HO1 = 0 in 35
	replace KtLt_HO2 = (9/(9-10))*(KtLt-10) in 35
	replace KtLt_HO3 = KtLt - 9 in 35
	replace KtLt_HO4 = 0 in 35
	replace VAL_HO1 = 0 in 35
	replace VAL_HO2 = ([#2]_b[KtLt_HO2])*(9/(9-10))*(KtLt-10) in 35
	replace VAL_HO3 = ([#3]_b[KtLt_HO3])*(KtLt-9) in 35
	replace VAL_HO4 = 0 in 35

	set obs 36
	replace year = 3004 in 36
	replace KtLt = 23.63904 in 36
	replace KtLt_HO1 = 0 in 36
	replace KtLt_HO2 = 0 in 36
	replace KtLt_HO3 = ((10-9)/(10-23.63904))*(KtLt-23.63904) in 36
	replace KtLt_HO4 = KtLt - 10 in 36
	replace VAL_HO1 = 0 in 36
	replace VAL_HO2 = 0 in 36
	replace VAL_HO3 = ([#3]_b[KtLt_HO3])*((10-9)/(10-23.63904))*(KtLt-23.63904) in 36
	replace VAL_HO4 = ([#4]_b[KtLt_HO4])*(KtLt-10) in 36

	predict hat1, equation(#1)
	predict hat2, equation(#2)
	predict hat3, equation(#3)
	predict hat4, equation(#4)

	predict stdf1, stdp equation(#1)
	predict stdf2, stdp equation(#2)
	predict stdf3, stdp equation(#3)
	predict stdf4, stdp equation(#4)

	drop KtLt_HO*
	reshape long VAL_HO hat stdf, i(year) j(HOind)
	rename VAL_HO VAL
	estat ic

	gen lo = hat - 1.96*stdf
	gen hi = hat + 1.96*stdf

	gen HO = HOind
	rename HOind Aggregates
	label define Aggregates_label 1 "Aggregate 1" 2 "Aggregate 2" 3 "Aggregate 3" 4 "Aggregate 4"
	label values Aggregates Aggregates_label
        label variable Aggregates "Aggregate"

	replace year = . if year > 3000
	gen str2 year2 = substr(string(year), 3, 2)
	drop year
	rename year2 year

scatter VAL KtLt, by(Aggregates, note("") legend(off) yrescale) mlabposition(0) mlabel(year) ms(i) || line hat KtLt, sort lcolor(black) || line lo KtLt, sort lcolor(black) lpattern(-) || line hi KtLt, sort lcolor(black) lpattern(-) ||, ytitle("Value-added per labor (Millions of Yen)") xtitle("Capital per labor ratio (Millions of Yen)") xline(9 10 23.63904, lstyle(grid)) xlab(9 10 23.6, grid)
graph save f5, replace

**************************************************************************************************
* Table 5: Five-good, four-cone model
**************************************************************************************************

use regdata, replace

gen m = 0.4
gen n = 0.6
gen o = 1.1
gen p = 1.4
	sort year
	by year: gen HOind = 1 if logKitLit < m
	by year: replace HOind = 2 if logKitLit >= m & logKitLit < n
	by year: replace HOind = 3 if logKitLit >= n & logKitLit < o
	by year: replace HOind = 4 if logKitLit >= o & logKitLit < p
	by year: replace HOind = 5 if logKitLit >= p
	*
	* aggregation id
	*
	sort year HOind
	gen year_HOind_id = string(year) + "-" + string(HOind)
	*
	* aggregation
	*
	keep year_HOind_id HOind year VAit Kt Lt wt
	collapse (mean) year HOind Kt Lt wt (sum) VAit, by(year_HOind_id)
	*
	* New id (year x HO aggregation)
	*
	sort year HOind
	gen temp_id = string(year) + "-" + string(HOind)
	sort temp_id
	egen id = group(temp_id)
	drop temp_id
	*
	* Heckscher-Ohlin aggregate of VAL
	*
	gen VAL_HO = VAit/Lt
	gen KtLt = Kt/Lt
	*
	* intercept
	*
	gen intercept = 1
	*
	* industry dummies
	*
	tabulate HOind, generate(HOind_d)
	*
	* d
	*
		keep year VAL_HO KtLt wt HOind
		sort year
		reshape wide VAL_HO, i(year) j(HOind)
		replace VAL_HO1 = 0 if VAL_HO1 == .
		replace VAL_HO2 = 0 if VAL_HO2 == .
		replace VAL_HO3 = 0 if VAL_HO3 == .
		replace VAL_HO4 = 0 if VAL_HO4 == .
		replace VAL_HO5 = 0 if VAL_HO5 == .
gen i = 10
gen j = 11
gen k = 13
gen l = 23.63904
		gen     d1 = 0
		replace d1 = 1 if KtLt < i
		gen     d2 = 0
		replace d2 = 1 if KtLt >= i & KtLt < j
		gen     d3 = 0
		replace d3 = 1 if KtLt >= j & KtLt < k
		gen     d4 = 0
		replace d4 = 1 if KtLt >= k

		gen KtLt_HO1 = (KtLt - i)*d1
		gen KtLt_HO2 = KtLt*d1 + (i/(i-j))*(KtLt-j)*d2
		gen KtLt_HO3 = (KtLt-i)*d2 + ((j-i)/(j-k))*(KtLt-k)*d3
		gen KtLt_HO4 = (KtLt-j)*d3 + ((k-j)/(k-l))*(KtLt-l)*d4
		gen KtLt_HO5 = (KtLt-k)*d4

		bootstrap, reps(1000) seed(10101) nodots: sureg (VAL_HO1 KtLt_HO1, noconstant) (VAL_HO2 KtLt_HO2, noconstant) (VAL_HO3 KtLt_HO3, noconstant) (VAL_HO4 KtLt_HO4, noconstant) (VAL_HO5 KtLt_HO5, noconstant), small dfk

sureg, notable noheader corr
estat ic

quietly log close
