quietly log using f3-f5t3.log, text replace
clear all
set memory 800m
set more off

**************************************************************************************************
* Figure 2 & Table 3: Two-good, single-cone model
**************************************************************************************************

use regdata, replace

gen m = 1
	sort pref_id
	by pref_id: gen HOind = 1 if logKirLir < m
	by pref_id: replace HOind = 2 if logKirLir >= m
	*
	* aggregation id
	*
	sort pref_id HOind
	gen pref_HOind_id = string(pref_id) + "-" + string(HOind)
	*
	* aggregation
	*
	keep pref_HOind_id HOind pref_id VAir Kr Lr wr
	collapse (mean) pref_id HOind Kr Lr wr (sum) VAir, by(pref_HOind_id)
	*
	* New id (prefecture x HO aggregation)
	*
	sort pref_id HOind
	gen temp_id = string(pref_id) + "-" + string(HOind)
	sort temp_id
	egen id = group(temp_id)
	drop temp_id
	*
	* Heckscher-Ohlin aggregate of VAL
	*
	gen VAL_HO = VAir/Lr
	gen KrLr = Kr/Lr
	*
	* intercept
	*
	gen intercept = 1
	*
	* industry dummies
	*
	tabulate HOind, generate(HOind_d)
	*
	* d
	*
		*
		* suppress constraint
		*
		keep pref_id VAL_HO KrLr wr HOind
		sort pref_id
		reshape wide VAL_HO, i(pref_id) j(HOind)
		replace VAL_HO1 = 0 if VAL_HO1 == .
		replace VAL_HO2 = 0 if VAL_HO2 == .
		rename wr VAL_HO3
gen i = 0
gen j = 28.64542
		gen     d1 = 0
		replace d1 = 1 if KrLr >= i
		gen KrLr_HO1 = (KrLr-j)*d1
		gen KrLr_HO2 = KrLr
		gen KrLr_w1  = d1
		constraint define 1 [VAL_HO3]KrLr_w1 = -[VAL_HO1]KrLr_HO1*28.64542

		bootstrap, reps(1000) seed(10101) nodots: sureg (VAL_HO1 KrLr_HO1, noconstant) (VAL_HO2 KrLr_HO2, noconstant) (VAL_HO3 KrLr_w1, noconstant), const(1) small dfk

sureg, notable noheader corr
estat ic

	set obs 48
	replace pref_id = 48 in 48
	replace KrLr = 0 in 48
	replace KrLr_HO1 = (KrLr-28.64542) in 48
	replace KrLr_HO2 = KrLr in 48
	replace KrLr_w1 = 1 in 48
	replace VAL_HO1 = ([#1]_b[KrLr_HO1])*(KrLr-28.64542) in 48
	replace VAL_HO2 = ([#2]_b[KrLr_HO2])*KrLr in 48
	replace VAL_HO3 = [#3]_b[KrLr_w1] in 48

	set obs 49
	replace pref_id = 49 in 49
	replace KrLr = 28.64542 in 49
	replace KrLr_HO1 = (KrLr-28.64542) in 49
	replace KrLr_HO2 = KrLr in 49
	replace KrLr_w1 = 1 in 49
	replace VAL_HO1 = ([#1]_b[KrLr_HO1])*(KrLr-28.6) in 49
	replace VAL_HO2 = ([#2]_b[KrLr_HO2])*KrLr in 49
	replace VAL_HO3 = [#3]_b[KrLr_w1] in 49

	predict hat1, equation(#1)
	predict hat2, equation(#2)
	predict hat3, equation(#3)

	predict stdf1, stdp equation(#1)
	predict stdf2, stdp equation(#2)
	predict stdf3, stdp equation(#3)

	drop KrLr_HO*
	reshape long VAL_HO hat stdf, i(pref_id) j(HOind)
	rename VAL_HO VAL

	gen lo = hat - 1.96*stdf
	gen hi = hat + 1.96*stdf

	gen HO = HOind
	rename HOind Aggregates
	label define Aggregates_label 1 "Aggregate 1" 2 "Aggregate 2" 3 "Wages"
	label values Aggregates Aggregates_label
	label variable Aggregates "Aggregate"

	replace pref_id = . if pref_id >= 48

scatter VAL KrLr, by(Aggregates, note("") legend(off) yrescale) mlabposition(0) mlabel(pref_id) ms(i) || line hat KrLr, sort lcolor(black) || line lo KrLr, sort lcolor(black) lpattern(-) || line hi KrLr, sort lcolor(black) lpattern(-) ||, ytitle("Value-added per labor and wages (Millions of Yen)") xtitle("Capital per labor ratio (Millions of Yen)") xline(0 28.64542, lstyle(grid)) xlab(0 28.6, grid)

graph save f3, replace

**************************************************************************************************
* Figure 4 & Table 3: Three-good, two-cone model
**************************************************************************************************

use regdata, replace

gen m = 0.5
gen n = 1.3
	sort pref_id
	by pref_id: gen HOind = 1 if logKirLir < m
	by pref_id: replace HOind = 2 if logKirLir >= m & logKirLir < n
	by pref_id: replace HOind = 3 if logKirLir >= n
	*
	* aggregation id
	*
	sort pref_id HOind
	gen pref_HOind_id = string(pref_id) + "-" + string(HOind)
	*
	* aggregation
	*
	keep pref_HOind_id HOind pref_id VAir Kr Lr wr
	collapse (mean) pref_id HOind Kr Lr wr (sum) VAir, by(pref_HOind_id)
	*
	* New id (prefecture x HO aggregation)
	*
	sort pref_id HOind
	gen temp_id = string(pref_id) + "-" + string(HOind)
	sort temp_id
	egen id = group(temp_id)
	drop temp_id
	*
	* Heckscher-Ohlin aggregate of VAL
	*
	gen VAL_HO = VAir/Lr
	gen KrLr = Kr/Lr
	*
	* intercept
	*
	gen intercept = 1
	*
	* industry dummies
	*
	tabulate HOind, generate(HOind_d)
	*
	* d
	*
		*
		* suppress constraint
		*
		keep pref_id VAL_HO KrLr wr HOind
		sort pref_id
		reshape wide VAL_HO, i(pref_id) j(HOind)
		replace VAL_HO1 = 0 if VAL_HO1 == .
		replace VAL_HO2 = 0 if VAL_HO2 == .
		replace VAL_HO3 = 0 if VAL_HO3 == .
		rename wr VAL_HO4

gen i = 10
gen j = 28.64542

		gen     d1 = 0
		replace d1 = 1 if KrLr <= i
		gen     d2 = 0
		replace d2 = 1 if KrLr > i
		gen KrLr_HO1 = (KrLr - i)*d1
		gen KrLr_HO2 = KrLr*d1+(i/(i-j))*(KrLr-j)*d2
		gen KrLr_HO3 = (KrLr-i)*d2
		gen KrLr_w1  = d1
		gen KrLr_w2  = d2

		constraint define 1 [VAL_HO4]KrLr_w1 = -[VAL_HO1]KrLr_HO1*10
		constraint define 2 [VAL_HO4]KrLr_w2 = ((-10)/(28.64542-10))*([VAL_HO3]KrLr_HO3*(28.64542-10)-[VAL_HO2]KrLr_HO2*28.64542)

		bootstrap, reps(1000) seed(10101) nodots: sureg (VAL_HO1 KrLr_HO1, noconstant) (VAL_HO2 KrLr_HO2, noconstant) (VAL_HO3 KrLr_HO3, noconstant) (VAL_HO4 KrLr_w1 KrLr_w2, noconstant), const(1 2) small dfk

sureg, notable noheader corr
estat ic

	set obs 48
	replace pref_id = 48 in 48
	replace KrLr = 0 in 48
	replace KrLr_HO1 = (KrLr-10) in 48
	replace KrLr_HO2 = KrLr in 48
	replace KrLr_HO3 = 0 in 48
	replace KrLr_w1 = 1 in 48
	replace KrLr_w2 = 0 in 48
	replace VAL_HO1 = ([#1]_b[KrLr_HO1])*(KrLr-10) in 48
	replace VAL_HO2 = 0 in 48
	replace VAL_HO3 = 0 in 48
	replace VAL_HO4 = ([#4]_b[KrLr_w1])*KrLr_w1 in 48

	set obs 49
	replace pref_id = 49 in 49
	replace KrLr = 10 in 49
	replace KrLr_HO1 = (KrLr-10) in 49
	replace KrLr_HO2 = KrLr in 49
	replace KrLr_HO3 = (KrLr-10) in 49
*
* Note: If KrLr_w1 = 1 & KrLr_w2 = 0, y-axis of wages will start from zero.
*
	replace KrLr_w1 = 0 in 49
	replace KrLr_w2 = 1 in 49
	replace VAL_HO1 = ([#1]_b[KrLr_HO1])*(KrLr-10) in 49
	replace VAL_HO2 = ([#2]_b[KrLr_HO2])*KrLr in 49
	replace VAL_HO3 = ([#3]_b[KrLr_HO3])*(KrLr-10) in 49
	replace VAL_HO4 = ([#4]_b[KrLr_w2])*KrLr_w2 in 49

	set obs 50
	replace pref_id = 50 in 50
	replace KrLr = 28.64542 in 50
	replace KrLr_HO1 = 0 in 50
	replace KrLr_HO2 = (10/(10-28.64542))*(KrLr-28.64542) in 50
	replace KrLr_HO3 = (KrLr-10) in 50
	replace KrLr_w1 = 0 in 50
	replace KrLr_w2 = 1 in 50
	replace VAL_HO1 = 0 in 50
	replace VAL_HO2 = ([#2]_b[KrLr_HO2])*(10/(10-28.64542))*(KrLr-28.64542) in 50
	replace VAL_HO3 = ([#3]_b[KrLr_HO3])*(KrLr-10) in 50
	replace VAL_HO4 = ([#4]_b[KrLr_w2])*KrLr_w2 in 50

	predict hat1, equation(#1)
	predict hat2, equation(#2)
	predict hat3, equation(#3)
	predict hat4, equation(#4)

	predict stdf1, stdp equation(#1)
	predict stdf2, stdp equation(#2)
	predict stdf3, stdp equation(#3)
	predict stdf4, stdp equation(#4)

	drop KrLr_HO*
	reshape long VAL_HO hat stdf, i(pref_id) j(HOind)
	rename VAL_HO VAL

	gen lo = hat - 1.96*stdf
	gen hi = hat + 1.96*stdf

	gen HO = HOind
	rename HOind Aggregates
	label define Aggregates_label 1 "Aggregate 1" 2 "Aggregate 2" 3 "Aggregate 3" 4 "Wages"
	label values Aggregates Aggregates_label
	label variable Aggregates "Aggregate"

	replace pref_id = . if pref_id >= 48

scatter VAL KrLr, by(Aggregates, note("") legend(off) yrescale) mlabposition(0) mlabel(pref_id) ms(i) || line hat KrLr, sort lcolor(black) || line lo KrLr, sort lcolor(black) lpattern(-) || line hi KrLr, sort lcolor(black) lpattern(-) ||, ytitle("Value-added per labor and wages (Millions of Yen)") xtitle("Capital per labor ratio (Millions of Yen)") xline(10 28.64542, lstyle(grid)) xlab(10 28.6, grid)
graph save f4, replace

**************************************************************************************************
* Figure 5 & Table 3: Four-good, three-cone model
**************************************************************************************************

use regdata, replace

gen m = 0.5
gen n = 1.2
gen o = 1.6
	sort pref_id
	by pref_id: gen HOind = 1 if logKirLir < m
	by pref_id: replace HOind = 2 if logKirLir >= m & logKirLir < n
	by pref_id: replace HOind = 3 if logKirLir >= n & logKirLir < o
	by pref_id: replace HOind = 4 if logKirLir >= o
	*
	* aggregation id
	*
	sort pref_id HOind
	gen pref_HOind_id = string(pref_id) + "-" + string(HOind)
	*
	* aggregation
	*
	keep pref_HOind_id HOind pref_id VAir Kr Lr wr
	collapse (mean) pref_id HOind Kr Lr wr (sum) VAir, by(pref_HOind_id)
	*
	* New id (prefecture x HO aggregation)
	*
	sort pref_id HOind
	gen temp_id = string(pref_id) + "-" + string(HOind)
	sort temp_id
	egen id = group(temp_id)
	drop temp_id
	*
	* Heckscher-Ohlin aggregate of VAL
	*
	gen VAL_HO = VAir/Lr
	gen KrLr = Kr/Lr
	*
	* intercept
	*
	gen intercept = 1
	*
	* industry dummies
	*
	tabulate HOind, generate(HOind_d)
	*
	* d
	*
		*
		* suppress constraint
		*
		keep pref_id VAL_HO KrLr wr HOind
		sort pref_id
		reshape wide VAL_HO, i(pref_id) j(HOind)
		replace VAL_HO1 = 0 if VAL_HO1 == .
		replace VAL_HO2 = 0 if VAL_HO2 == .
		replace VAL_HO3 = 0 if VAL_HO3 == .
		replace VAL_HO4 = 0 if VAL_HO4 == .
		rename wr VAL_HO5

gen i = 10
gen j = 17
gen k = 28.64542

		gen     d1 = 0
		replace d1 = 1 if KrLr <= i
		gen     d2 = 0
		replace d2 = 1 if KrLr > i & KrLr <= j
		gen     d3 = 0
		replace d3 = 1 if KrLr > j
		gen KrLr_HO1 = (KrLr - i)*d1
		gen KrLr_HO2 = KrLr*d1 + (i/(i-j))*(KrLr-j)*d2
		gen KrLr_HO3 = (KrLr-i)*d2+((j-i)/(j-k))*(KrLr-k)*d3
		gen KrLr_HO4 = (KrLr-j)*d3
		gen KrLr_w1  = d1
		gen KrLr_w2  = d2
		gen KrLr_w3  = d3

		constraint define 1 [VAL_HO5]KrLr_w1 = -[VAL_HO1]KrLr_HO1*10
		constraint define 2 [VAL_HO5]KrLr_w2 = ((-10)/(17-10))*([VAL_HO3]KrLr_HO3*(17-10)-[VAL_HO2]KrLr_HO2*17)
		constraint define 3 [VAL_HO5]KrLr_w3 = (1/(28.64542-17))*([VAL_HO3]KrLr_HO3*28.64542*(17-10)-[VAL_HO4]KrLr_HO4*17*(28.64542-17))

		bootstrap, reps(1000) seed(10101) nodots: sureg (VAL_HO1 KrLr_HO1, noconstant) (VAL_HO2 KrLr_HO2, noconstant) (VAL_HO3 KrLr_HO3, noconstant) (VAL_HO4 KrLr_HO4, noconstant) (VAL_HO5 KrLr_w1 KrLr_w2 KrLr_w3, noconstant), const(1 2 3) small dfk

sureg, notable noheader corr
estat ic

	set obs 48
	replace pref_id = 48 in 48
	replace KrLr = 0 in 48
	replace KrLr_HO1 = KrLr - 10 in 48
	replace KrLr_HO2 = 0 in 48
	replace KrLr_HO3 = 0 in 48
	replace KrLr_HO4 = 0 in 48
	replace KrLr_w1 = 1 in 48
	replace KrLr_w2 = 0 in 48
	replace KrLr_w3 = 0 in 48
	replace VAL_HO1 = ([#1]_b[KrLr_HO1])*(KrLr-10) in 48
	replace VAL_HO2 = 0 in 48
	replace VAL_HO3 = 0 in 48
	replace VAL_HO4 = 0 in 48

	set obs 49
	replace pref_id = 49 in 49
	replace KrLr = 10 in 49
	replace KrLr_HO1 = KrLr - 10 in 49
	replace KrLr_HO2 = KrLr in 49
	replace KrLr_HO3 = KrLr - 10 in 49
	replace KrLr_HO4 = 0 in 49
	replace KrLr_w1 = 1 in 49
	replace KrLr_w2 = 0 in 49
	replace KrLr_w3 = 0 in 49
	replace VAL_HO1 = ([#1]_b[KrLr_HO1])*(KrLr-10) in 49
	replace VAL_HO2 = ([#2]_b[KrLr_HO2])*KrLr in 49
	replace VAL_HO3 = ([#3]_b[KrLr_HO3])*(KrLr-10) in 49
	replace VAL_HO4 = 0 in 49

	set obs 50
	replace pref_id = 50 in 50
	replace KrLr = 17 in 50
	replace KrLr_HO1 = 0 in 50
	replace KrLr_HO2 = (10/(10-17))*(KrLr-17) in 50
	replace KrLr_HO3 = KrLr - 10 in 50
	replace KrLr_HO4 = 0 in 50
	replace KrLr_w1 = 0 in 50
	replace KrLr_w2 = 1 in 50
	replace KrLr_w3 = 0 in 50
	replace VAL_HO1 = 0 in 50
	replace VAL_HO2 = ([#2]_b[KrLr_HO2])*(10/(10-17))*(KrLr-17) in 50
	replace VAL_HO3 = ([#3]_b[KrLr_HO3])*(KrLr-10) in 50
	replace VAL_HO4 = 0 in 50

	set obs 51
	replace pref_id = 51 in 51
	replace KrLr = 28.64542 in 51
	replace KrLr_HO1 = 0 in 51
	replace KrLr_HO2 = 0 in 51
	replace KrLr_HO3 = ((17-10)/(17-28.64542))*(KrLr-28.64542) in 51
	replace KrLr_HO4 = KrLr - 17 in 51
	replace KrLr_w1 = 0 in 51
	replace KrLr_w2 = 0 in 51
	replace KrLr_w3 = 1 in 51
	replace VAL_HO1 = 0 in 51
	replace VAL_HO2 = 0 in 51
	replace VAL_HO3 = ([#3]_b[KrLr_HO3])*((17-10)/(17-28.64542))*(KrLr-28.64542) in 51
	replace VAL_HO4 = ([#4]_b[KrLr_HO4])*(KrLr-17) in 51

	predict hat1, equation(#1)
	predict hat2, equation(#2)
	predict hat3, equation(#3)
	predict hat4, equation(#4)
	predict hat5, equation(#5)

	predict stdf1, stdp equation(#1)
	predict stdf2, stdp equation(#2)
	predict stdf3, stdp equation(#3)
	predict stdf4, stdp equation(#4)
	predict stdf5, stdp equation(#5)

	drop KrLr_HO*
	reshape long VAL_HO hat stdf, i(pref_id) j(HOind)
	rename VAL_HO VAL

	gen lo = hat - 1.96*stdf
	gen hi = hat + 1.96*stdf

	gen HO = HOind
	rename HOind Aggregates
	label define Aggregates_label 1 "Aggregate 1" 2 "Aggregate 2" 3 "Aggregate 3" 4 "Aggregate 4" 5 "Wages"
	label values Aggregates Aggregates_label
	label variable Aggregates "Aggregate"

	replace pref_id = . if pref_id >= 48

scatter VAL KrLr, by(Aggregates, note("") legend(off) yrescale) mlabposition(0) mlabel(pref_id) ms(i) || line hat KrLr, sort lcolor(black) || line lo KrLr, sort lcolor(black) lpattern(-) || line hi KrLr, sort lcolor(black) lpattern(-) ||, ytitle("Value-added per labor and wages (Millions of Yen)") xtitle("Capital per labor ratio (Millions of Yen)") xline(10 17 28.64542, lstyle(grid)) xlab(10 17 28.6, grid)
graph save f5, replace

**************************************************************************************************
* Table 3: Five-good, four-cone model
**************************************************************************************************

use regdata, replace

gen m = 0.5
gen n = 1.2
gen o = 1.6
gen p = 1.7
	sort pref_id
	by pref_id: gen HOind = 1 if logKirLir < m
	by pref_id: replace HOind = 2 if logKirLir >= m & logKirLir < n
	by pref_id: replace HOind = 3 if logKirLir >= n & logKirLir < o
	by pref_id: replace HOind = 4 if logKirLir >= o & logKirLir < p
	by pref_id: replace HOind = 5 if logKirLir >= p
	*
	* aggregation id
	*
	sort pref_id HOind
	gen pref_HOind_id = string(pref_id) + "-" + string(HOind)
	*
	* aggregation
	*
	keep pref_HOind_id HOind pref_id VAir Kr Lr wr
	collapse (mean) pref_id HOind Kr Lr wr (sum) VAir, by(pref_HOind_id)
	*
	* New id (prefecture x HO aggregation)
	*
	sort pref_id HOind
	gen temp_id = string(pref_id) + "-" + string(HOind)
	sort temp_id
	egen id = group(temp_id)
	drop temp_id
	*
	* Heckscher-Ohlin aggregate of VAL
	*
	gen VAL_HO = VAir/Lr
	gen KrLr = Kr/Lr
	*
	* intercept
	*
	gen intercept = 1
	*
	* industry dummies
	*
	tabulate HOind, generate(HOind_d)
	*
	* d
	*
		*
		* suppress constraint
		*
		keep pref_id VAL_HO KrLr wr HOind
		sort pref_id
		reshape wide VAL_HO, i(pref_id) j(HOind)
		replace VAL_HO1 = 0 if VAL_HO1 == .
		replace VAL_HO2 = 0 if VAL_HO2 == .
		replace VAL_HO3 = 0 if VAL_HO3 == .
		replace VAL_HO4 = 0 if VAL_HO4 == .
		replace VAL_HO5 = 0 if VAL_HO5 == .
		rename wr VAL_HO6

gen i = 10
gen j = 23
gen k = 26
gen l = 28.64542

		gen     d1 = 0
		replace d1 = 1 if KrLr < i
		gen     d2 = 0
		replace d2 = 1 if KrLr >= i & KrLr < j
		gen     d3 = 0
		replace d3 = 1 if KrLr >= j & KrLr < k
		gen     d4 = 0
		replace d4 = 1 if KrLr >= k

		gen KrLr_HO1 = (KrLr - i)*d1
		gen KrLr_HO2 = KrLr*d1 + (i/(i-j))*(KrLr-j)*d2
		gen KrLr_HO3 = (KrLr-i)*d2 + ((j-i)/(j-k))*(KrLr-k)*d3
		gen KrLr_HO4 = (KrLr-j)*d3 + ((k-j)/(k-l))*(KrLr-l)*d4
		gen KrLr_HO5 = (KrLr-k)*d4
		gen KrLr_w1  = d1
		gen KrLr_w2  = d2
		gen KrLr_w3  = d3
		gen KrLr_w4  = d4

		constraint define 1 [VAL_HO6]KrLr_w1 = -[VAL_HO1]KrLr_HO1*10
		constraint define 2 [VAL_HO6]KrLr_w2 = (10/(23-10))*([VAL_HO2]KrLr_HO2*23-[VAL_HO3]KrLr_HO3*(23-10))
		constraint define 3 [VAL_HO6]KrLr_w3 = (1/(26-23))*([VAL_HO3]KrLr_HO3*26*(23-10)-[VAL_HO4]KrLr_HO4*23*(26-23))
		constraint define 4 [VAL_HO6]KrLr_w4 = (1/(28.64542-26))*([VAL_HO4]KrLr_HO4*28.64542*(26-23)-[VAL_HO5]KrLr_HO5*26*(28.64542-26))

		bootstrap, reps(1000) seed(10101) nodots: sureg (VAL_HO1 KrLr_HO1, noconstant) (VAL_HO2 KrLr_HO2, noconstant) (VAL_HO3 KrLr_HO3, noconstant) (VAL_HO4 KrLr_HO4, noconstant) (VAL_HO5 KrLr_HO5, noconstant) (VAL_HO6 KrLr_w1 KrLr_w2 KrLr_w3 KrLr_w4, noconstant), const(1 2 3 4) small dfk

sureg, notable noheader corr
estat ic

quietly log close
