quietly log using t2.log, text replace

set memory 800m
set matsize 5000
set more off

use ind_id pref_id KirLir year using regdata
keep if year == 1995
replace KirLir = 0 if KirLir == .
*
* Rank correlation
*
keep pref_id ind_id KirLir
sort pref_id ind_id
reshape wide KirLir, i(ind_id) j(pref_id)
quietly: spearman KirLir1-KirLir47
matrix M = r(Rho)
drop ind_id KirLir1-KirLir47
matrix v = vec(M)
svmat v, names(reg_ind_corr)
save reg_ind_corr, replace
clear

use reg_ind_corr, clear
drop if reg_ind_corr == 1

gen     group = 0
replace group = 11 if reg_ind_corr >= 0
replace group = 10 if reg_ind_corr >= 0.1
replace group = 9 if reg_ind_corr >= 0.2
replace group = 8 if reg_ind_corr >= 0.3
replace group = 7 if reg_ind_corr >= 0.4
replace group = 6 if reg_ind_corr >= 0.5
replace group = 5 if reg_ind_corr >= 0.6
replace group = 4 if reg_ind_corr >= 0.7
replace group = 3 if reg_ind_corr >= 0.8
replace group = 2 if reg_ind_corr >= 0.9
replace group = 1 if reg_ind_corr == 1
*
* NOTE: Divide by 2 (because of the symmetry of the correlation matrix)
*
table group, m

clear
erase reg_ind_corr.dta
quietly log close
