quietly log using f9t4.log, text replace
set memory 400m
set more off

	use regdata, replace
gen n = 12
	keep if year == 1995
	sort year pref_id
	by year pref_id: gen HOind = 1 if KirLir < n
	by year pref_id: replace HOind = 2 if KirLir >= n
	*
	* aggregation id
	*
	sort pref_id HOind year
	gen pref_HOind_year_id = string(pref_id) + "-" + string(HOind) + "-" + string(year)
	*
	* aggregation
	*
	keep pref_HOind_year_id year HOind pref_id VAir Kr Lr wr
	collapse (mean) year pref_id HOind Kr Lr wr (sum) VAir, by(pref_HOind_year_id)
	*
	* New id (prefecture x HO aggregation)
	*
	sort pref_id HOind year
	gen temp_id = string(pref_id) + "-" + string(HOind)
	sort temp_id
	egen id = group(temp_id)
	drop temp_id
	*tsset id year
	*
	* Heckscher-Ohlin aggregate of VAL
	*
	gen VAL_HO = VAir/Lr
	gen KrLr = Kr/Lr
	*
	* intercept
	*
	gen intercept = 1
	*
	* industry dummies
	*
	tabulate HOind, generate(HOind_d)
	*
	* d
	*
		*
		* suppress constraint
		*
		keep pref_id year VAL_HO KrLr wr HOind
		sort pref_id year
		reshape wide VAL_HO, i(pref_id year) j(HOind)
		replace VAL_HO1 = 0 if VAL_HO1 == .
		replace VAL_HO2 = 0 if VAL_HO2 == .
		rename wr VAL_HO3
gen i = 3
gen j = 26.00636
		gen     d2 = 0
		replace d2 = 1 if KrLr >= i
		gen KrLr_HO1 = (KrLr-j)*d2
		gen KrLr_HO2 = (KrLr-i)*d2
		gen KrLr_w1  = d2
		constraint define 1 [VAL_HO3]KrLr_w1 = -[VAL_HO1]KrLr_HO1*26.00636-[VAL_HO2]KrLr_HO2*3

		sureg (VAL_HO1 KrLr_HO1, noconstant) (VAL_HO2 KrLr_HO2, noconstant) (VAL_HO3 KrLr_w1, noconstant), const(1)

	set obs 48
	replace year = 1995 in 48
	replace pref_id = 48 in 48
	replace VAL_HO1 = 0 in 48
	replace VAL_HO2 = 0 in 48
	replace KrLr = 1 in 48
	replace KrLr_HO1 = 0 in 48
	replace KrLr_HO2 = 0 in 48

	set obs 49
	replace year = 1995 in 49
	replace pref_id = 49 in 49
	replace VAL_HO1 = ([#1]_b[KrLr_HO1])*(3 - 26.00636) in 49
	replace VAL_HO2 = 0 in 49
	replace VAL_HO3 = [#3]_b[KrLr_w1] in 49
	replace KrLr = 3 in 49
	replace KrLr_HO1 = 3 - 26.00636 in 49
	replace KrLr_HO2 = 0 in 49
	replace KrLr_w1 = 1 in 49

	predict hat1, equation(#1)
	predict hat2, equation(#2)
	predict hat3, equation(#3)

	predict stdf1, stdp equation(#1)
	predict stdf2, stdp equation(#2)
	predict stdf3, stdp equation(#3)

	drop KrLr_HO*
	reshape long VAL_HO hat stdf, i(pref_id year) j(HOind)
	rename VAL_HO VAL
	estat ic

	gen lo = hat - 1.96*stdf
	gen hi = hat + 1.96*stdf

	gen HO = HOind
	rename HOind Aggregates
	label define Aggregates_label 1 "Intermediate capital-intensive aggregate" 2 "Capital-intensive aggregate" 3 "Wages"
	label values Aggregates Aggregates_label

	replace pref_id = . if pref_id >= 48

scatter VAL KrLr, by(Aggregates, note("") legend(off) yrescale) mlabposition(0) mlabel(pref_id) ms(i) || line hat KrLr, sort lcolor(black) || line lo KrLr, sort lcolor(black) lpattern(-) || line hi KrLr, sort lcolor(black) lpattern(-) ||, ytitle("Value-added per region labor and Wages (Millions of Yen)") xtitle("Capital per labor ratio (Millions of Yen)") xline(3 26.00636, lstyle(grid)) xlab(3 26, grid)
graph save f9, replace

keep if HO == 3
keep if pref_id != .
corr VAL hat

gen diff = abs(VAL - hat)
sum diff, detail

quietly log close
