quietly log using f8t3.log, text replace
set memory 400m
set matsize 5000
set more off

**************************************************************************************************
* Figure 8 & Table 3
**************************************************************************************************

	use regdata, replace
gen m = 3
gen n = 21
	keep if year == 1995
	sort year pref_id
	by year pref_id: gen HOind = 1 if KirLir != . & KirLir < m
	by year pref_id: replace HOind = 1 if KirLir == . & KiLi < m
	by year pref_id: replace HOind = 2 if KirLir != . & (KirLir >= m & KirLir < n)
	by year pref_id: replace HOind = 2 if KirLir == . & (KiLi >= m & KiLi < n)
	by year pref_id: replace HOind = 3 if KirLir != . & KirLir >= n
	by year pref_id: replace HOind = 3 if KirLir == . & KiLi >= n
	*
	* aggregation id
	*
	sort pref_id HOind year
	gen pref_HOind_year_id = string(pref_id) + "-" + string(HOind) + "-" + string(year)
	*
	* aggregation
	*
	keep pref_HOind_year_id year HOind pref_id VAir Kr Lr wr
	collapse (mean) year pref_id HOind Kr Lr wr (sum) VAir, by(pref_HOind_year_id)
	table pref_id HOind, c(n VAir)
	*
	* New id (prefecture x HO aggregation)
	*
	sort pref_id HOind year
	gen temp_id = string(pref_id) + "-" + string(HOind)
	sort temp_id
	egen id = group(temp_id)
	drop temp_id
	*tsset id year
	*
	* Heckscher-Ohlin aggregate of VAL
	*
	gen VAL_HO = VAir/Lr
	gen KrLr = Kr/Lr
	*
	* intercept
	*
	gen intercept = 1
	*
	* industry dummies
	*
	tabulate HOind, generate(HOind_d)
	*
	* d
	*
		*
		* capital intensity
		*
			*
			* 8 < tau2 < 26, 8< tau4 < 26
			*
gen i = 1
gen k = 9

gen s = 0.05
gen t = 0.30
gen u = 0.55

			gen tau2 = (t/(1-t))/(s/(1-s))*i
			gen tau4 = (u/(1-u))/(t/(1-t))*k
			*
			* change format from long to wide
			*
			keep pref_id year VAL_HO KrLr wr HOind
			sort pref_id year
			reshape wide VAL_HO, i(pref_id) j(HOind)
gen i = 1
gen k = 9

gen s = 0.05
gen t = 0.30
gen u = 0.55
			*
			* d
			*
			gen tau2 = (t/(1-t))/(s/(1-s))*i
			gen tau4 = (u/(1-u))/(t/(1-t))*k
			*
			gen     d1 = 0
			replace d1 = 1 if KrLr >= 0 & KrLr < i
			gen     d2 = 0
			replace d2 = 1 if KrLr >= i & KrLr < tau2
			gen     d3 = 0
			replace d3 = 1 if KrLr >= tau2 & KrLr < k
			gen     d4 = 0
			replace d4 = 1 if KrLr >= k & KrLr < tau4
			gen     d5 = 0
			replace d5 = 1 if KrLr >= tau4
			*
			* dependent variables
			*
			replace VAL_HO1 = 0 if VAL_HO1 == .
			replace VAL_HO2 = 0 if VAL_HO2 == .
			replace VAL_HO3 = 0 if VAL_HO3 == .
			rename wr VAL_HO4
			*
			* independent variables (suppress constraint)
			*
			gen KrLr_HO1 = (KrLr^s)*d1 + ((i^s)/(i-tau2))*(KrLr - tau2)*d2
			gen KrLr_HO2 = (s/t)*((i^(s-1))/(tau2^(t-1)))*(((tau2^t)/(tau2-i))*(KrLr-i)*d2+(KrLr^t)*d3+((k^t)/(k-tau4))*(KrLr-tau4)*d4)
			gen KrLr_HO3 = (s/u)*((i^(s-1))/(tau2^(t-1)))*((k^(t-1))/(tau4^(u-1)))*(((tau4^u)/(tau4-k))*(KrLr-k)*d4 + (KrLr^u)*d5)
			gen KrLr_w = ((1-s)*(KrLr^s))*d1 + ((1-s)*(i^s))*d2 + ((1/(k-tau2))*(((s*(i^(s-1)))/(t*(tau2^(t-1))))*(k^t)*(1-t)-(i^s)*(1-s))*(KrLr-tau2) + (i^s)*(1-s))*d3 + (((s*(i^(s-1)))/(t*(tau2^(t-1))))*(k^t)*(1-t))*d4 + ((1-u)*(s/u)*((i^(s-1))/(tau2^(t-1)))*((k^(t-1))/(tau4^(u-1)))*(KrLr^u))*d5

			constraint define 1 [VAL_HO1]KrLr_HO1 = [VAL_HO2]KrLr_HO2
			constraint define 2 [VAL_HO1]KrLr_HO1 = [VAL_HO3]KrLr_HO3
			constraint define 3 [VAL_HO1]KrLr_HO1 = [VAL_HO4]KrLr_w
			sureg (VAL_HO1 KrLr_HO1, noconstant) (VAL_HO2 KrLr_HO2, noconstant) (VAL_HO3 KrLr_HO3, noconstant) (VAL_HO4 KrLr_w, noconstant), const(1 2 3)
			estat ic
	*
	set obs 48
	replace year = 1995 in 48
	replace pref_id = 48 in 48
	replace VAL_HO1 = 0 in 48
	replace VAL_HO2 = 0 in 48
	replace VAL_HO3 = 0 in 48
	replace KrLr = 0 in 48
	replace KrLr_HO1 = 0 in 48
	replace KrLr_HO2 = 0 in 48
	replace KrLr_HO3 = 0 in 48

	set obs 49
	replace year = 1995 in 49
	replace pref_id = 49 in 49
	replace VAL_HO1 = ([#1]_b[KrLr_HO1])*(1^0.05) in 49
	replace VAL_HO2 = 0 in 49
	replace VAL_HO3 = 0 in 49
	replace VAL_HO4 = (1-0.05)*([#4]_b[KrLr_w])*(1^0.05) in 49
	replace KrLr = 1 in 49
	replace KrLr_HO1 = ((1^0.05)/(1-8.142858))*(1-8.142858) in 49
	replace KrLr_HO2 = 0 in 49
	replace KrLr_HO3 = 0 in 49
	replace KrLr_w = (1-0.05)*(1^0.05) in 49

	set obs 50
	replace year = 1995 in 50
	replace pref_id = 50 in 50
	replace VAL_HO1 = ([#1]_b[KrLr_HO1])*(0.5^0.05) in 50
	replace VAL_HO2 = 0 in 50
	replace VAL_HO3 = 0 in 50
	replace VAL_HO4 = (1-0.05)*([#4]_b[KrLr_w])*(0.5^0.05) in 50
	replace KrLr = 0.5 in 50
	replace KrLr_HO1 = ((0.5^0.05)/(0.5-8.142858))*(0.5-8.142858) in 50
	replace KrLr_HO2 = 0 in 50
	replace KrLr_HO3 = 0 in 50
	replace KrLr_w = (1-0.05)*(0.5^0.05) in 50

	set obs 51
	replace year = 1995 in 51
	replace pref_id = 51 in 51
	replace VAL_HO1 = ([#1]_b[KrLr_HO1])*(0.3^0.05) in 51
	replace VAL_HO2 = 0 in 51
	replace VAL_HO3 = 0 in 51
	replace VAL_HO4 = (1-0.05)*([#4]_b[KrLr_w])*(0.3^0.05) in 51
	replace KrLr = 0.3 in 51
	replace KrLr_HO1 = ((0.3^0.05)/(0.3-8.142858))*(0.3-8.142858) in 51
	replace KrLr_HO2 = 0 in 51
	replace KrLr_HO3 = 0 in 51
	replace KrLr_w = (1-0.05)*(0.3^0.05) in 51

	set obs 52
	replace year = 1995 in 52
	replace pref_id = 52 in 52
	replace VAL_HO1 = ([#1]_b[KrLr_HO1])*(0.2^0.05) in 52
	replace VAL_HO2 = 0 in 52
	replace VAL_HO3 = 0 in 52
	replace VAL_HO4 = (1-0.05)*([#4]_b[KrLr_w])*(0.2^0.05) in 52
	replace KrLr = 0.2 in 52
	replace KrLr_HO1 = ((0.2^0.05)/(0.2-8.142858))*(0.2-8.142858) in 52
	replace KrLr_HO2 = 0 in 52
	replace KrLr_HO3 = 0 in 52
	replace KrLr_w = (1-0.05)*(0.2^0.05) in 52

	predict hat1, equation(#1)
	predict hat2, equation(#2)
	predict hat3, equation(#3)
	predict hat4, equation(#4)

	predict stdf1, stdp equation(#1)
	predict stdf2, stdp equation(#2)
	predict stdf3, stdp equation(#3)
	predict stdf4, stdp equation(#4)

	drop KrLr_HO* KrLr_w
	reshape long VAL_HO hat stdf, i(pref_id) j(HOind)
	rename VAL_HO VAL

	gen lo = hat - 1.96*stdf
	gen hi = hat + 1.96*stdf

	gen HO = HOind
	rename HOind Aggregates
	label define Aggregates_label 1 "Labor-intensive aggregate" 2 "Intermediate capital-intensive aggregate" 3 "Capital-intensive aggregate" 4 "Wages"
	label values Aggregates Aggregates_label

	replace pref_id = . if pref_id >= 48
*
* pref_id
*
scatter VAL KrLr, by(Aggregates, note("") legend(off) yrescale) mlabposition(0) mlabel(pref_id) ms(i) || line hat KrLr, sort lcolor(black) || line lo KrLr, sort lcolor(black) lpattern(-) || line hi KrLr, sort lcolor(black) lpattern(-) ||, ytitle("Value-added per region labor and Wages (Millions of Yen)") xtitle("Capital per labor ratio (Millions of Yen)") xline(1 8 9 26, lstyle(grid)) xlab(1 8 9 26, grid)

graph save f8, replace

keep if HO == 4
keep if pref_id != .
corr VAL hat

gen diff = abs(VAL - hat)
sum diff, detail

quietly log close
