quietly log using f10t4.log, text replace
set memory 400m
set matsize 5000
set more off

**************************************************************************************************
* Figure 10 & Table 4
**************************************************************************************************

	use regdata, replace
gen m = 3
	keep if year == 1995
	sort year pref_id
	by year pref_id: gen HOind = 1 if KirLir != . & KirLir < m
	by year pref_id: replace HOind = 1 if KirLir == . & KiLi < m
	by year pref_id: replace HOind = 2 if KirLir != . & KirLir >= m
	by year pref_id: replace HOind = 2 if KirLir == . & KiLi >= m
	*
	* aggregation id
	*
	sort pref_id HOind year
	gen pref_HOind_year_id = string(pref_id) + "-" + string(HOind) + "-" + string(year)
	*
	* aggregation
	*
	keep pref_HOind_year_id year HOind pref_id VAir Kr Lr wr
	collapse (mean) year pref_id HOind Kr Lr wr (sum) VAir, by(pref_HOind_year_id)
	table pref_id HOind, c(n VAir)
	*
	* New id (prefecture x HO aggregation)
	*
	sort pref_id HOind year
	gen temp_id = string(pref_id) + "-" + string(HOind)
	sort temp_id
	egen id = group(temp_id)
	drop temp_id
	*tsset id year
	*
	* Heckscher-Ohlin aggregate of VAL
	*
	gen VAL_HO = VAir/Lr
	gen KrLr = Kr/Lr
	*
	* intercept
	*
	gen intercept = 1
	*
	* industry dummies
	*
	tabulate HOind, generate(HOind_d)
	*
	* d
	*
		*
		* capital intensity
		*
			*
			* 8 < tau2 < 26, 8< tau4 < 26
			*
gen k = 1

gen t = 0.10
gen u = 0.50

			gen tau4 = (u/(1-u))/(t/(1-t))*k
			*
			* change format from long to wide
			*
			keep pref_id year VAL_HO KrLr wr HOind
			sort pref_id year
			reshape wide VAL_HO, i(pref_id) j(HOind)
gen k = 1

gen t = 0.10
gen u = 0.50
			*
			* d
			*
			gen tau4 = (u/(1-u))/(t/(1-t))*k
			*
			gen     d4 = 0
			replace d4 = 1 if KrLr >= k & KrLr < tau4
			gen     d5 = 0
			replace d5 = 1 if KrLr >= tau4
			*
			* dependent variables
			*
			replace VAL_HO1 = 0 if VAL_HO1 == .
			replace VAL_HO2 = 0 if VAL_HO2 == .
			rename wr VAL_HO3
			*
			* independent variables (suppress constraint)
			*
			gen KrLr_HO1 = ((k^t)/(k-tau4))*(KrLr - tau4)*d4
			gen KrLr_HO2 = (t/u)*((k^(t-1))/(tau4^(u-1)))*(((tau4^u)/(tau4-k))*(KrLr-k)*d4 + (KrLr^u)*d5)

			gen KrLr_w = (1-t)*(k^t)*d4 + (t/u)*((k^(t-1))/(tau4^(u-1)))*(1-u)*(KrLr^u)*d5

			display "********** HO n & d k & d tau4 & theta t & theta u **********"
			constraint define 1 [VAL_HO1]KrLr_HO1 = [VAL_HO2]KrLr_HO2
			constraint define 2 [VAL_HO1]KrLr_HO1 = [VAL_HO3]KrLr_w
			sureg (VAL_HO1 KrLr_HO1, noconstant) (VAL_HO2 KrLr_HO2, noconstant) (VAL_HO3 KrLr_w, noconstant), const(1 2)
			estat ic
	set obs 48
	replace year = 1995 in 48
	replace pref_id = 48 in 48
	replace VAL_HO1 = ([#1]_b[KrLr_HO1])*((1^0.1)/(1-9))*(1 - 9) in 48
	replace VAL_HO2 = 0 in 48
	replace VAL_HO3 = ([#1]_b[KrLr_HO1])*(1-0.1)*(1^0.1) in 48
	replace KrLr = 1 in 48
	replace KrLr_HO1 = ((1^0.1)/(1-9))*(1 - 9) in 48
	replace KrLr_HO2 = 0 in 48
	replace KrLr_w = (1-0.1)*(1^0.1) in 48

	set obs 49
	replace year = 1995 in 49
	replace pref_id = 49 in 49
	replace VAL_HO2 = 0 in 49
	replace KrLr = 0 in 49
	replace KrLr_HO2 = 0 in 49

	*
	predict hat1, equation(#1)
	predict hat2, equation(#2)
	predict hat3, equation(#3)

	predict stdf1, stdp equation(#1)
	predict stdf2, stdp equation(#2)
	predict stdf3, stdp equation(#3)

	drop KrLr_HO* KrLr_w
	reshape long VAL_HO hat stdf, i(pref_id) j(HOind)
	rename VAL_HO VAL

	gen lo = hat - 1.96*stdf
	gen hi = hat + 1.96*stdf

	gen HO = HOind
	rename HOind Aggregates
	label define Aggregates_label 1 "Intermediate capital-intensive aggregate" 2 "Capital-intensive aggregate" 3 "Wages"
	label values Aggregates Aggregates_label

	replace pref_id = . if pref_id >= 48
*
* pref_id
*
scatter VAL KrLr, by(Aggregates, note("") legend(off) yrescale) mlabposition(0) mlabel(pref_id) ms(i) || line hat KrLr, sort lcolor(black) || line lo KrLr, sort lcolor(black) lpattern(-) || line hi KrLr, sort lcolor(black) lpattern(-) ||, ytitle("Value-added per region labor and Wages (Millions of Yen)") xtitle("Capital per labor ratio (Millions of Yen)") xline(1 9, lstyle(grid)) xlab(1 9, grid)

graph save f10, replace

keep if HO == 3
keep if pref_id != .
corr VAL hat

gen diff = abs(VAL - hat)
sum diff, detail

quietly log close
