clear all
log using reg4.txt, text replace
*
* boycott
*
use boycott, clear

************************************************************************************************************************
* Disaggregate-level analysis
************************************************************************************************************************

preserve
drop if country == 0 /* drop total */
gen lnvisitor = ln(visitor)
rename s_kor s
rename hhi h
*rename theil h
gen     KOR = 0
replace KOR = 1 if country == 1
gen     Post = 0
replace Post = 1 if ym > 50
gen sKOR = s * KOR
gen KORPost = KOR * Post
gen sPost = Post * s
gen sKORPost = s * KOR * Post

*
* Table C6 (2) & C7 (2)
*
sum s, detail

drop if reg_id == 35 | reg_id == 40 | reg_id == 41 | reg_id == 44

sum s, detail

forvalues i = 0/57 {
   gen     dym`i' = 0
   replace dym`i' = 1 if ym == `i'
   gen sKORdym`i' = s*KOR*dym`i'
   }
drop sKORdym27

* regression 

*
* long-term verion
*
sort reg_id country year

*
* Table C5 (1)
*
reghdfe lnvisitor sKOR KORPost sPost sKORPost, absorb(country reg_id ym) vce(cluster country reg_id ym)
*
* mid-term version
*
keep if ym >= 39

sort reg_id country year
*
* Table C5 (2)
*
reghdfe lnvisitor sKOR KORPost sPost sKORPost, absorb(country reg_id ym) vce(cluster country reg_id ym)

restore

************************************************************************************************************************
* Aggregate-level analysis
************************************************************************************************************************

preserve
keep year month ym country reg_id prefecture visitor s_kor
keep if country == 0
gen lnvisitor = ln(visitor)
rename  s_kor s
gen     Post = 0
replace Post = 1 if ym > 50
gen sPost = s * Post

drop if reg_id == 35 | reg_id == 40 | reg_id == 41 | reg_id == 44

forvalues i = 0/57 {
   gen     dym`i' = 0
   replace dym`i' = 1 if ym == `i'
   gen sdym`i' = s*dym`i'
   }
drop sdym27
   
* regression 
*
* long-term version
*
*
* Table C5 (3)
*
reghdfe lnvisitor sPost, absorb(reg_id ym) vce(cluster reg_id ym)
*
* mid-term version
*
keep if ym >= 39
*
* Table C5 (4)
*
reghdfe lnvisitor sPost, absorb(reg_id ym) vce(cluster reg_id ym)

restore

log close
