clear all
log using reg3.txt, text replace
*
* boycott
*
use boycott, clear

drop if reg_id == 1 | reg_id == 13 | reg_id == 27 | reg_id == 40 | reg_id == 47

************************************************************************************************************************
* Disaggregate-level analysis
************************************************************************************************************************

preserve
drop if country == 0 /* drop total */
gen lnvisitor = ln(visitor)
rename s_kor s
gen     KOR = 0
replace KOR = 1 if country == 1
gen     Post = 0
replace Post = 1 if ym > 50
gen sKOR = s * KOR
gen KORPost = KOR * Post
gen sPost = Post * s
gen sKORPost = s * KOR * Post

*
* Table C3 (2) & Table C4 (2)
*
sum s, detail

forvalues i = 0/57 {
   gen     dym`i' = 0
   replace dym`i' = 1 if ym == `i'
   gen sKORdym`i' = s*KOR*dym`i'
   }
drop sKORdym27

* regression 

*
* long-term verion
*
sort reg_id country year

*
* Table C2 (1)
*
reghdfe lnvisitor sKOR KORPost sPost sKORPost, absorb(country reg_id ym) vce(cluster country reg_id ym)

gen trend = ym
gen strend = trend * s
gen sKORtrend = KOR*trend*s
gen KORtrend = KOR*trend
*
* Table C1 (1)
*
reghdfe lnvisitor sKORtrend strend KORtrend sKOR if Post == 0, absorb(country reg_id ym) vce(cluster country reg_id ym)

drop trend KORtrend strend sKORtrend
*
* mid-term version
*
keep if ym >= 39

sort reg_id country year
*
* Table C2 (2)
*
reghdfe lnvisitor sKOR KORPost sPost sKORPost, absorb(country reg_id ym) vce(cluster country reg_id ym)

gen trend = ym - 39
gen strend = trend * s
gen sKORtrend = KOR*trend*s
gen KORtrend = KOR*trend
*
* Table C1 (2)
*
reghdfe lnvisitor sKORtrend strend KORtrend sKOR if Post == 0, absorb(country reg_id ym) vce(cluster country reg_id ym)

drop trend KORtrend strend sKORtrend
*
* short-term version
*
keep if year >= 2019

gen trend = ym - 45
gen strend = trend * s
gen sKORtrend = KOR*trend*s
gen KORtrend = KOR*trend
* drop trend due to the collinearity with ym
*
* Table C1 (3)
*
reghdfe lnvisitor sKORtrend strend KORtrend sKOR if Post == 0, absorb(country reg_id ym) vce(cluster country reg_id ym)

drop trend KORtrend strend sKORtrend

restore

************************************************************************************************************************
* Aggregate-level analysis
************************************************************************************************************************

preserve
keep year month ym country reg_id prefecture visitor s_kor
keep if country == 0
gen lnvisitor = ln(visitor)
rename  s_kor s
gen     Post = 0
replace Post = 1 if ym > 50
gen sPost = s * Post

forvalues i = 0/57 {
   gen     dym`i' = 0
   replace dym`i' = 1 if ym == `i'
   gen sdym`i' = s*dym`i'
   }
drop sdym27
   
* regression 
*
* long-term version
*
*
* Table C2 (3)
*
reghdfe lnvisitor sPost, absorb(reg_id ym) vce(cluster reg_id ym)

gen trend = ym
gen strend = trend*s
*
* Table C1 (4)
*
reghdfe lnvisitor strend if Post == 0, absorb(reg_id ym) vce(cluster reg_id ym)

drop trend strend
*
* mid-term version
*
keep if ym >= 39
*
* Table C2 (4)
*
reghdfe lnvisitor sPost, absorb(reg_id ym) vce(cluster reg_id ym)

gen trend = ym - 39
gen strend = trend*s
*
* Table C1 (5)
*
reghdfe lnvisitor strend if Post == 0, absorb(reg_id ym) vce(cluster reg_id ym)

drop trend strend
*
* short-term version
*
keep if year >= 2019
*
* Table C1 (6)
*
gen trend = ym - 45
gen strend = trend*s

reghdfe lnvisitor strend if Post == 0, absorb(reg_id ym) vce(cluster reg_id ym)

drop trend strend

restore

log close
