clear all
log using reg2.txt, text replace
use boycott, clear

************************************************************************************************************************
* Disaggregate-level analysis
************************************************************************************************************************
preserve
drop if country == 0 /* drop total */
gen lnvisitor = ln(visitor)
rename s_kor s
gen     KOR = 0
replace KOR = 1 if country == 1
gen     Post = 0
replace Post = 1 if ym > 50
gen sKOR = s * KOR
gen KORPost = KOR * Post
gen sPost = Post * s
gen sKORPost = s * KOR * Post

sort reg_id ym
egen fit = group(reg_id ym)
sort country ym
egen fjt = group(country ym)
sort reg_id country
egen fij = group(reg_id country)

sum s, detail

forvalues i = 0/57 {
   gen     dym`i' = 0
   replace dym`i' = 1 if ym == `i'
   gen sKORdym`i' = s*KOR*dym`i'
   }
drop sKORdym27

* regression 

*
* long-term verion
*
sort reg_id country year

*
* Table 3 (3)
*
reghdfe lnvisitor sKORPost, absorb(fit fjt fij) vce(cluster country reg_id ym)
*
* Table A1 (3)
*
ppmlhdfe visitor sKORPost, d(fixed) absorb(fit fjt fij) cluster(reg_id country ym)
  predict fitted, xbd
  correl visitor fitted
  display "***** R^2 *****"
  di r(rho)^2
drop fitted fixed
*
* mid-term version
*
drop fit fjt fij
keep if ym >= 39
sort reg_id ym
egen fit = group(reg_id ym)
sort country ym
egen fjt = group(country ym)
sort reg_id country
egen fij = group(reg_id country)

sort reg_id country year
*
* Table 3 (4)
*
reghdfe lnvisitor sKORPost, absorb(fit fjt fij) vce(cluster country reg_id ym)
*
* Table A1 (4)
*
ppmlhdfe visitor sKORPost, d(fixed) absorb(fit fjt fij) cluster(reg_id country ym)
  predict fitted, xbd
  correl visitor fitted
  display "***** R^2 *****"
  di r(rho)^2

restore

log close
