clear all
log using reg1.txt, text replace
*
* boycott
*
*
use boycott, clear

***********************************************************************************************************************
* Disaggregate-level analysis
***********************************************************************************************************************

preserve
drop if country == 0
gen lnvisitor = ln(visitor)
rename s_kor s
rename hhi h
gen     KOR = 0
replace KOR = 1 if country == 1
gen     Post = 0
replace Post = 1 if ym > 50
gen sKOR = s * KOR
gen KORPost = KOR * Post
gen sPost = Post * s
gen sKORPost = s * KOR * Post
gen hKOR = h * KOR
gen hPost = Post * h
gen hKORPost = h * KOR * Post

*
* Table 4 (2) & 8 (2)
*
sum s, detail

forvalues i = 0/57 {
   gen     dym`i' = 0
   replace dym`i' = 1 if ym == `i'
   gen sKORdym`i' = s*KOR*dym`i'
   }
drop sKORdym27

* regression 

*
* long-term verion
*
sort reg_id country year

*
* Table 3 (1)
*
reghdfe lnvisitor sKOR KORPost sPost sKORPost, absorb(country reg_id ym) vce(cluster country reg_id ym)
*
* Table B2 (1)
*
reghdfe lnvisitor hKOR KORPost hPost hKORPost, absorb(country reg_id ym) vce(cluster country reg_id ym)
*
* Figure 5 data
* c. = continuous variable
*
reghdfe lnvisitor sKOR KOR#i.ym c.s#i.ym sKORdym*, absorb(country reg_id ym) vce(cluster country reg_id ym)
*
* Table A1 (1)
*
ppmlhdfe visitor sKOR KORPost sPost sKORPost, d(fixed) absorb(country reg_id ym) cluster(reg_id country ym)
  predict fit, xbd
  correl visitor fit
  display "***** R^2 *****"
  di r(rho)^2

gen trend = ym
gen strend = trend * s
gen sKORtrend = KOR*trend*s
gen KORtrend = KOR*trend
gen htrend = ym * h
gen hKORtrend = KOR*trend*h
*
* Table 2 (1)
*
reghdfe lnvisitor sKORtrend strend KORtrend sKOR if Post == 0, absorb(country reg_id ym) vce(cluster country reg_id ym)
*
* Table B1 (1)
*
reghdfe lnvisitor hKORtrend htrend KORtrend hKOR if Post == 0, absorb(country reg_id ym) vce(cluster country reg_id ym)
drop trend KORtrend strend sKORtrend htrend hKORtrend fixed fit
*
* mid-term version
*
keep if ym >= 39
sort reg_id country year
*
* Table 3 (2)
*
reghdfe lnvisitor sKOR KORPost sPost sKORPost, absorb(country reg_id ym) vce(cluster country reg_id ym)
*
* Table B2 (2)
*
reghdfe lnvisitor hKOR KORPost hPost hKORPost, absorb(country reg_id ym) vce(cluster country reg_id ym)
*
* Table A1 (2)
*
ppmlhdfe visitor sKOR KORPost sPost sKORPost, d(fixed) absorb(country reg_id ym) cluster(reg_id country ym)
  predict fit, xbd
  correl visitor fit
  display "***** R^2 *****"
  di r(rho)^2

gen trend = ym - 39
gen strend = trend * s
gen sKORtrend = KOR*trend*s
gen KORtrend = KOR*trend
gen htrend = trend * h
gen hKORtrend = KOR*trend*h
* drop trend due to the collinearity with ym
*
* Table 2 (2)
*
reghdfe lnvisitor sKORtrend strend KORtrend sKOR if Post == 0, absorb(country reg_id ym) vce(cluster country reg_id ym)
*
* Table B1 (2)
*
reghdfe lnvisitor hKORtrend htrend KORtrend hKOR if Post == 0, absorb(country reg_id ym) vce(cluster country reg_id ym)
drop trend KORtrend strend sKORtrend htrend hKORtrend fixed fit
*
* short-term version
*
keep if year >= 2019
*
* Table B2 (3)
*
reghdfe lnvisitor hKOR KORPost hPost hKORPost, absorb(country reg_id ym) vce(cluster country reg_id ym)

gen trend = ym - 45
gen strend = trend * s
gen sKORtrend = KOR*trend*s
gen KORtrend = KOR*trend
gen htrend = trend * h
gen hKORtrend = KOR*trend*h
* drop trend due to the collinearity with ym
*
* Table 2 (3)
*
reghdfe lnvisitor sKORtrend strend KORtrend sKOR if Post == 0, absorb(country reg_id ym) vce(cluster country reg_id ym)
*
* Table B1 (3)
*
reghdfe lnvisitor hKORtrend htrend KORtrend hKOR if Post == 0, absorb(country reg_id ym) vce(cluster country reg_id ym)
drop trend KORtrend strend sKORtrend htrend hKORtrend

restore

***********************************************************************************************************************
* Aggregate-level analysis
***********************************************************************************************************************

preserve
keep year month ym country reg_id prefecture visitor s_kor hhi
keep if country == 0
gen lnvisitor = ln(visitor)
rename  s_kor s
rename hhi h
gen     Post = 0
replace Post = 1 if ym > 50
gen sPost = s * Post
gen hPost = h * Post

xi, pre(FT) i.ym
char ym[omit]0
xi, pre(FR) i.reg_id

forvalues i = 0/57 {
   gen     dym`i' = 0
   replace dym`i' = 1 if ym == `i'
   gen sdym`i' = s*dym`i'
   }
drop sdym27
   
*
* regression 
*
* long-term version
*
*
* Table 7 (1)
*
reghdfe lnvisitor sPost, absorb(reg_id ym) vce(cluster reg_id ym)
*
* Table B2 (4)
*
reghdfe lnvisitor hPost, absorb(reg_id ym) vce(cluster reg_id ym)
*
* Figure 5 data
*
reghdfe lnvisitor sdym*, absorb(reg_id ym) vce(cluster reg_id ym)
*
* Table A1 (5)
*
ppmlhdfe visitor sPost, d(fixed) absorb(reg_id ym) cluster(reg_id ym)
  predict fit, xbd
  correl visitor fit
  display "***** R^2 *****"
  di r(rho)^2

gen trend = ym
gen strend = trend*s
gen htrend = trend*h
*
* Table 6 (1)
*
reghdfe lnvisitor strend if Post == 0, absorb(reg_id ym) vce(cluster reg_id ym)
*
* Table B1 (4)
*
reghdfe lnvisitor htrend if Post == 0, absorb(reg_id ym) vce(cluster reg_id ym)
drop trend strend htrend fixed fit
*
* mid-term version
*
keep if ym >= 39
*
* Table 7 (2)
*
reghdfe lnvisitor sPost, absorb(reg_id ym) vce(cluster reg_id ym)
*
* Table B2 (5)
*
reghdfe lnvisitor hPost, absorb(reg_id ym) vce(cluster reg_id ym)
*
* Table A1 (6)
*
ppmlhdfe visitor sPost, d(fixed) absorb(reg_id ym) cluster(reg_id ym)
  predict fit, xbd
  correl visitor fit
  display "***** R^2 *****"
  di r(rho)^2

gen trend = ym - 39
gen strend = trend*s
gen htrend = trend*h
*
* Table 6 (2)
*
reghdfe lnvisitor strend if Post == 0, absorb(reg_id ym) vce(cluster reg_id ym)
*
* Table B1 (5)
*
reghdfe lnvisitor htrend if Post == 0, absorb(reg_id ym) vce(cluster reg_id ym)
drop trend strend htrend fixed fit
*
* short-term version
*
keep if year >= 2019
*
* Table B2 (6)
*
reghdfe lnvisitor hPost, absorb(reg_id ym) vce(cluster reg_id ym)

gen trend = ym - 45
gen strend = trend*s
gen htrend = trend*h
*
* Table 6 (3)
*
reghdfe lnvisitor strend if Post == 0, absorb(reg_id ym) vce(cluster reg_id ym)
*
* Table B1 (6)
*
reghdfe lnvisitor htrend if Post == 0, absorb(reg_id ym) vce(cluster reg_id ym)
drop trend strend htrend

restore

************************************************************************************************************************
* Table D1
************************************************************************************************************************

preserve
keep year month ym country visitor
drop if country == 0
sort year month ym country
collapse (sum) visitor, by(year month ym country)
gen lnvisitor = ln(visitor)
gen     KOR = 0
replace KOR = 1 if country == 1
gen     Post = 0
replace Post = 1 if ym > 50
gen KORPost = KOR * Post

sum visitor lnvisitor /* check the number of observations */

* event study data
* xi: reg lnvisitor i.ym*KOR i.country, vce(robust)

* regression 
*
* long-term version
*
gen trend = ym
gen pretrend = KOR*trend
*
* Table D1 (1)
*
reghdfe lnvisitor pretrend if Post == 0, absorb(country ym) vce(cluster country ym)
*
* Table D1 (4)
*
reghdfe lnvisitor pretrend i.country#i.month if Post == 0, absorb(country ym) vce(cluster country ym)
drop trend pretrend
*
* mid-term version
*
keep if ym >= 39
gen trend = ym - 39
gen pretrend = KOR*trend
*
* Table D1 (2)
*
reghdfe lnvisitor pretrend if Post == 0, absorb(country ym) vce(cluster country ym)
drop trend pretrend
*
* short-term version
*
keep if year >= 2019

gen trend = ym - 45
gen pretrend = KOR*trend
*
* Table D1 (3)
*
reghdfe lnvisitor pretrend if Post == 0, absorb(country ym) vce(cluster country ym)
drop trend pretrend

restore

***********************************************************************************************************************
* Figure 6
***********************************************************************************************************************

keep year month ym country visitor
drop if country == 0
sort year month ym country
collapse (sum) visitor, by(year month ym country)
gen lnvisitor = ln(visitor)
gen     KOR = 0
replace KOR = 1 if country == 1

forvalues i = 0/57 {
   gen     dym`i' = 0
   replace dym`i' = 1 if ym == `i'
   gen KORdym`i' = KOR*dym`i'
   }
replace KORdym27 = 0

reghdfe lnvisitor KORdym*, absorb(country ym) vce(cluster country ym)
regsave KORdym* using ci_to_Japan_95.dta, ci level(95) replace

use ci_to_Japan_95, clear

gen     ym=substr(var, -2,2)
replace ym=substr(var, -1,1) if var == "KORdym0"
replace ym=substr(var, -1,1) if var == "KORdym1"
replace ym=substr(var, -1,1) if var == "KORdym2"
replace ym=substr(var, -1,1) if var == "KORdym3"
replace ym=substr(var, -1,1) if var == "KORdym4"
replace ym=substr(var, -1,1) if var == "KORdym5"
replace ym=substr(var, -1,1) if var == "KORdym6"
replace ym=substr(var, -1,1) if var == "KORdym7"
replace ym=substr(var, -1,1) if var == "KORdym8"
replace ym=substr(var, -1,1) if var == "KORdym9"
destring ym, replace
replace ym = ym + 663
format ym %tm

sum ym
sort ym

twoway rarea ci_lower ci_upper ym, color("gray%50") ///
xtitle("Year and month") ytitle("Estimated 95% confidence interval") ///
graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
legend(label(1 "Coefficient estimate") label(2 "Estimated 95% confidence interval") ) ///
yline(0,  lcolor(black)) ///
xlabel(`r(min)'(3)`r(max)', format(%tm) labsize(small) angle(vertical)) ///
tline(2019m7, lcolor(black) lpattern(solid))

graph export f6.pdf, as(pdf) replace

log close
