clear all

***********************************************************************************************************************
* Figure 7
***********************************************************************************************************************

use departure_from_Korea, clear

bys year country: egen number=count(Y)
bys country: egen min_number=min(number)
bys country: egen mean_number=mean(number)
drop if mean_number<10

keep if tm >= 663

gen lnvisitor=ln(Y)
gen Japan=1 if Destination=="Japan"
replace Japan=0 if Japan~=1

////no observations in 2020 Feb
drop if tm==721

xi i.tm
gen _Itm_663=1 if tm==663 /* 2015m4 = 663 */
replace _Itm_663=0 if tm~=663
*replace _Itm_713=0 /* 2019m6 */
replace _Itm_690=0 /* 2017m7 */

forvalues i=663/720 {
gen Japan_tm`i'=Japan*_Itm_`i'
}

reghdfe lnvisitor Japan_tm*, absorb(Destination tm) cluster(Destination tm)
regsave Japan_tm* using ci_to_Japan_95.dta, ci level(95) replace
*
* Common Trends Assumption
*
gen     Post = 0
replace Post = 1 if tm > 713

gen trend = tm - 663
gen pretrend = Japan*trend
*
* Table D2 (1)
*
reghdfe lnvisitor pretrend if Post == 0, absorb(country tm) vce(cluster country tm)

use ci_to_Japan_95.dta, clear

gen tm=substr(var, -3,3)
destring tm, replace
format tm %tm

sum tm
sort tm

twoway rarea ci_lower ci_upper tm, color("gray%50") ///
xtitle("Year and month") ytitle("Estimated 95% confidence interval") ///
graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
legend(label(1 "Coefficient estimate") label(2 "Estimated 95% confidence interval") ) ///
yline(0,  lcolor(black)) ///
xlabel(`r(min)'(3)`r(max)', format(%tm) labsize(small) angle(vertical)) ///
tline(2019m7, lcolor(black) lpattern(solid))

graph export f7.pdf, as(pdf) replace

clear all

***********************************************************************************************************************
* Figure 8
***********************************************************************************************************************

use arrival_to_Korea, clear

keep if tm >= 663

gen lnvisitor=ln(Y)
gen Japan=1 if Country=="Japan"
replace Japan=0 if Japan~=1

////no observations in 2020 Feb
drop if tm==721

xi i.tm
gen _Itm_663=1 if tm==663 /* 2015m4 = 663 */
replace _Itm_663=0 if tm~=663
*replace _Itm_713=0 /* 2019m6 */
replace _Itm_690=0 /* 2017m7 */

forvalues i=663/720 {
gen Japan_tm`i'=Japan*_Itm_`i'
}

reghdfe lnvisitor Japan_tm*, absorb(Country tm) cluster(Country tm)
regsave Japan_tm* using ci_from_Japan_95.dta, ci level(95) replace
*
* Common Trends Assumption
*
gen     Post = 0
replace Post = 1 if tm > 713

gen trend = tm - 663
gen pretrend = Japan*trend
*
* Table D2 (2)
*
reghdfe lnvisitor pretrend if Post == 0, absorb(country tm) vce(cluster country tm)
*
* Figure
*
use ci_from_Japan_95.dta, clear
gen tm=substr(var, -3,3)
destring tm, replace
format tm %tm

sum tm
sort tm

twoway rarea ci_lower ci_upper tm, color("gray%50") ///
xtitle("Year and month") ytitle("Estimated 95% confidence interval") ///
graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
legend(label(1 "Coefficient estimate") label(2 "Estimated 95% confidence interval") ) ///
yline(0,  lcolor(black)) ///
xlabel(`r(min)'(3)`r(max)', format(%tm) labsize(small) angle(vertical)) ///
tline(2019m7, lcolor(black) lpattern(solid))

graph export f8.pdf, as(pdf) replace
