clear all
log using f1-f5fc1.txt, text replace
*
* boycott
*
insheet using visitor_data.csv, com clear
***********************************************************************************************************************
* Figure 1
***********************************************************************************************************************

preserve
keep if prefecture == "All"
keep if year >= 2015
drop if month == 0
gen time = ym(year, month)
format %tm time
drop year month

keep time jpn kor chn usa
sum jpn kor chn usa
gen total = log10(jpn/1000)
replace kor = log10(kor/1000)
replace chn = log10(chn/1000)
replace usa = log10(usa/1000)
sum total kor chn usa

sum time
sort time
line total time, lcolor(black) lpattern(solid) || line kor time, lcolor(black) lpattern(longdash) || line chn time, lcolor(black) lpattern(shortdash) || line usa time, lcolor(black) lpattern(dot) ///
legend(label(1 "Total") label(2 "Korea") label(3 "China") label(4 "United States")) ///
graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
xlabel(`r(min)'(6)`r(max)', format(%tm) labsize(small) angle(vertical)) ///
ylabel(2 "100" 2.477 "300" 2.699 "500" 3 "1,000" 3.699 "5,000" 4 "10,000", angle(horizontal)) ///
ytitle("Number of foreign visitors in Japan (1,000)", size(small)) ///
xtitle("Year and month") ///
tline(2019m7, lcolor(black) lpattern(solid))

graph export f1.pdf, as(pdf) replace
restore

***********************************************************************************************************************
* Figure 5
***********************************************************************************************************************

preserve
use timing, clear

gen time = ym(year, month)
format %tm time

sum time
sort time
twoway rarea dmax95 dmin95 time, color("gray%20") || rarea amax95 amin95 time, color("gray%50") /// 
legend(label(1 "Disaggregate-level results") label(2 "Aggregate-level results")) ///
graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
xlabel(`r(min)'(3)`r(max)', format(%tm) labsize(small) angle(vertical)) ///
ytitle("Estimated 95% confidence interval", size(small)) ///
xtitle("Year and month") ///
yline(0,  lcolor(black)) ///
tline(2019m7, lcolor(black) lpattern(solid))

graph export f5.pdf, as(pdf) replace
restore

***********************************************************************************************************************
* Table 1 data
***********************************************************************************************************************

preserve
keep if prefecture == "All"
keep if year >= 2015 & year <= 2019
keep if month == 0
drop month row

rename jpn visitor0
rename kor visitor1
rename chn visitor2
rename hkg visitor3
rename twn visitor4
rename usa visitor5
rename can visitor6
rename gbr visitor7
rename deu visitor8
rename fra visitor9
rename rus visitor10
rename sgp visitor11
rename tha visitor12
rename mys visitor13
rename ind visitor14
rename aus visitor15
rename idn visitor16
rename vnm visitor17
rename phl visitor18
rename ita visitor19
rename esp visitor20

forvalues i=1/20 {
   gen s`i' = visitor`i'/visitor0
}

keep s* visitor* year
reshape long s visitor, i(year) j(country)

gen str3 iso3_o = "KOR" if country == 1
replace  iso3_o = "CHN" if country == 2
replace  iso3_o = "HKG" if country == 3
replace  iso3_o = "TWN" if country == 4
replace  iso3_o = "USA" if country == 5
replace  iso3_o = "CAN" if country == 6
replace  iso3_o = "GBR" if country == 7
replace  iso3_o = "DEU" if country == 8
replace  iso3_o = "FRA" if country == 9
replace  iso3_o = "RUS" if country == 10
replace  iso3_o = "SGP" if country == 11
replace  iso3_o = "THA" if country == 12
replace  iso3_o = "MYS" if country == 13
replace  iso3_o = "IND" if country == 14
replace  iso3_o = "AUS" if country == 15
replace  iso3_o = "IDN" if country == 16
replace  iso3_o = "VNM" if country == 17
replace  iso3_o = "PHL" if country == 18
replace  iso3_o = "ITA" if country == 19
replace  iso3_o = "ESP" if country == 20

by year: egen rank = rank(1/s)
sort year rank
outsheet using t1data.csv, com replace
restore

***********************************************************************************************************************
* Figure 2
***********************************************************************************************************************

preserve
insheet using depend_kor.csv, com clear

rename id_1 ID_1
merge 1:1 ID_1 using japan_pref-d
   table _merge
   drop if _merge != 3
   drop _merge
save Japanmap, replace
generate label = reg_id
keep ID_1 x_cntrd y_cntrd label

use Japanmap, clear
spmap depend_kor using japan_pref-c, id(ID_1) clnumber(4) legend(position(11)) legtitle("Share of Visitors from Korea") fcolor(Blues)
graph export f2.png, replace

erase Japanmap.dta

restore

***********************************************************************************************************************
* Figure 3
************************************************************************************************************************
preserve
keep if prefecture == "All"
keep if reg_id == 0
drop if month == 0
gen time = ym(year, month)
format %tm time
keep year month time kor
tsset time
gen dkor = kor - l12.kor
drop if year == 2010
sum time
graph twoway bar dkor time, xlabel(`r(min)'(3)`r(max)', format(%tm) labsize(small) angle(vertical)) ///
graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
xtitle("Year and month") ///
ytitle("YOY changes in the number of visitors from Korea") ///
tline(2019m7, lcolor(black) lpattern(solid))

graph export f3.pdf, as(pdf) replace
restore

***********************************************************************************************************************
* Figure 4
***********************************************************************************************************************

preserve
drop if prefecture == "All"
drop if month == 0
drop if year < 2015
sort year month
egen ym = group(year month)
drop if ym <= 3 /* ITA & ESP are not available */
gen s_kor = kor/jpn
replace s_kor = . if ym > 54
sort reg_id ym
by reg_id: egen depend_kor = mean(s_kor)
keep if year == 2019
keep if month == 12
keep prefecture reg_id year month depend_kor jpn
sort depend_kor
outsheet using f4data.csv, com replace
restore

preserve
drop if prefecture == "All"
keep if year == 2018 | year == 2019
keep if month == 0

replace kor = kor/1000

keep year kor reg_id prefecture
label define reg_id 1 "Hokkaido" 2 "Aomori" 3 "Iwate" 4 "Miyagi" 5 "Akita" 6 "Yamagata" 7 "Fukushima" 8 "Ibaraki" 9 "Tochigi" 10 "Gumma" 11 "Saitama" 12 "Chiba" 13 "Tokyo" 14 "Kanagawa" 15 "Niigata" 16 "Toyama" 17 "Ishikawa" 18 "Fukui" 19 "Yamanashi" 20 "Nagano" 21 "Gifu" 22 "Shizuoka" 23 "Aichi" 24 "Mie" 25 "Shiga" 26 "Kyoto" 27 "Osaka" 28 "Hyogo" 29 "Nara" 30 "Wakayama" 31 "Tottori" 32 "Shimane" 33 "Okayama" 34 "Hiroshima" 35 "Yamaguchi" 36 "Tokushima" 37 "Kagawa" 38 "Ehime" 39 "Kochi" 40 "Fukuoka" 41 "Saga" 42 "Nagasaki" 43 "Kumamoto" 44 "Oita" 45 "Miyazaki" 46 "Kagoshima" 47 "Okinawa"

sort reg_id year
reshape wide kor, i(reg_id) j(year)
egen rank2018 = rank(kor2018)

label define rank2018 1 "Fukui" 2 "Tokushima" 3 "Fukushima" 4 "Kochi" 5 "Yamagata" 6 "Akita" 7 "Shimane" 8 "Miyagi" 9 "Iwate" 10 "Ibaraki" 11 "Gumma" 12 "Nara" 13 "Tochigi" 14 "Niigata" 15 "Saitama" 16 "Toyama" 17 "Mie" 18 "Ishikawa" 19 "Yamanashi" 20 "Wakayama" 21 "Aomori" 22 "Ehime" 23 "Hiroshima" 24 "Yamaguchi" 25 "Shiga" 26 "Gifu" 27 "Tottori" 28 "Okayama" 29 "Nagano" 30 "Kagawa" 31 "Shizuoka" 32 "Miyazaki" 33 "Hyogo" 34 "Kanagawa" 35 "Aichi" 36 "Kagoshima" 37 "Chiba" 38 "Saga" 39 "Nagasaki" 40 "Kyoto" 41 "Kumamoto" 42 "Oita" 43 "Okinawa" 44 "Hokkaido" 45 "Fukuoka" 46 "Tokyo" 47 "Osaka"

sort rank2018
line kor2018 rank2018, lcolor(black) lpattern(solid) || line kor2019 rank2018, lcolor(black) lpattern(longdash) ///
legend(label(1 "2018") label(2 "2019")) ///
graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) ///
xlabel(1 "Fukui" 2 "Tokushima" 3 "Fukushima" 4 "Kochi" 5 "Yamagata" 6 "Akita" 7 "Shimane" 8 "Miyagi" 9 "Iwate" 10 "Ibaraki" 11 "Gumma" 12 "Nara" 13 "Tochigi" 14 "Niigata" 15 "Saitama" 16 "Toyama" 17 "Mie" 18 "Ishikawa" 19 "Yamanashi" 20 "Wakayama" 21 "Aomori" 22 "Ehime" 23 "Hiroshima" 24 "Yamaguchi" 25 "Shiga" 26 "Gifu" 27 "Tottori" 28 "Okayama" 29 "Nagano" 30 "Kagawa" 31 "Shizuoka" 32 "Miyazaki" 33 "Hyogo" 34 "Kanagawa" 35 "Aichi" 36 "Kagoshima" 37 "Chiba" 38 "Saga" 39 "Nagasaki" 40 "Kyoto" 41 "Kumamoto" 42 "Oita" 43 "Okinawa" 44 "Hokkaido" 45 "Fukuoka" 46 "Tokyo" 47 "Osaka", labsize(small) angle(vertical)) ///
ytitle("Number of Visitors from Korea, by Prefecture (1,000)", size(small)) ///
xtitle("Prefecture")

graph export fc1.pdf, as(pdf) replace

gen change = ln(kor2019/kor2018)
keep reg_id change
sort reg_id
save change, replace

insheet using f4data.csv, com clear
keep reg_id prefecture depend_kor
sort reg_id
merge 1:1 reg_id using change
table _merge
drop _merge

keep prefecture change depend_kor
label variable change "Changes in the number of visitors from Korea, 2018-2019"
label variable depend_kor "Average share of visitors from Korea between April 2015 and June 2019"

twoway (lfitci change depend_kor, level(90) color("gray%20")) (scatter change depend_kor, legend(off) note("") graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) sort mcolor(black) msize(medium) msymbol(oh) mlabel(prefecture) mlabsize(vsmall) mlabposition(1)), ytitle("Changes in the number of visitors from Korea, 2018-2019") xtitle("Average share of visitors from Korea between April 2015 and June 2019")

graph export f4.pdf, as(pdf) replace

reg change depend_kor
correl change depend_kor
erase change.dta
erase f4data.csv
restore

log close
